/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.network;

import de.sarocesch.sarosroadblocksmod.SarosRoadBlocksModMod;
import de.sarocesch.sarosroadblocksmod.client.render.RoadPlannerClientRender;
import de.sarocesch.sarosroadblocksmod.config.ModConfigs;
import de.sarocesch.sarosroadblocksmod.item.RoadPlannerItem;
import de.sarocesch.sarosroadblocksmod.road.RoadPlannerManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RoadPlannerPackets {
    public static void encode(C2SClick msg, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)msg.action);
        buf.m_130064_(msg.pos == null ? BlockPos.f_121853_ : msg.pos);
    }

    public static C2SClick decode(FriendlyByteBuf buf) {
        C2SClick.Action act = (C2SClick.Action)buf.m_130066_(C2SClick.Action.class);
        BlockPos pos = buf.m_130135_();
        return new C2SClick(act, pos.equals((Object)BlockPos.f_121853_) ? null : pos);
    }

    public static void handle(C2SClick msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context c = ctx.get();
        c.enqueueWork(() -> {
            ServerPlayer sender = c.getSender();
            if (sender == null) {
                return;
            }
            switch (msg.action) {
                case ADD: {
                    RoadPlannerManager.addWaypoint(sender.m_9236_(), (Player)sender, msg.pos);
                    break;
                }
                case CLEAR: {
                    RoadPlannerManager.clearWaypoints(sender.m_9236_(), (Player)sender);
                    break;
                }
                case BUILD: {
                    RoadPlannerManager.buildPlannedRoad(sender.m_9236_(), (Player)sender);
                    break;
                }
                case REMOVE: {
                    RoadPlannerManager.removeNearestWaypoint(sender.m_9236_(), (Player)sender, msg.pos, 0.75);
                }
            }
        });
        c.setPacketHandled(true);
    }

    public static void encodeSync(S2CSyncWaypoints msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.points.size());
        for (BlockPos bp : msg.points) {
            buf.m_130064_(bp);
        }
    }

    public static S2CSyncWaypoints decodeSync(FriendlyByteBuf buf) {
        int n = buf.readInt();
        ArrayList<BlockPos> pts = new ArrayList<BlockPos>(n);
        for (int i = 0; i < n; ++i) {
            pts.add(buf.m_130135_());
        }
        return new S2CSyncWaypoints(pts);
    }

    public static void handleSync(S2CSyncWaypoints msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context c = ctx.get();
        c.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            RoadPlannerClientRender.setClientWaypoints(msg.points);
            if (((Boolean)ModConfigs.DEBUG_ROAD_PLANNER.get()).booleanValue()) {
                SarosRoadBlocksModMod.LOGGER.info("[RoadPlannerNet] client synced {} waypoints", (Object)msg.points.size());
            }
        }));
        c.setPacketHandled(true);
    }

    public static void encodeWidth(C2SSetWidth msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.width);
    }

    public static C2SSetWidth decodeWidth(FriendlyByteBuf buf) {
        return new C2SSetWidth(buf.readInt());
    }

    public static void handleWidth(C2SSetWidth msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context c = ctx.get();
        c.enqueueWork(() -> {
            ServerPlayer sender = c.getSender();
            if (sender == null) {
                return;
            }
            ItemStack held = sender.m_21205_();
            if (!held.m_41619_() && held.m_41720_() instanceof RoadPlannerItem) {
                RoadPlannerItem.setWidth(held, msg.width);
            }
        });
        c.setPacketHandled(true);
    }

    @SubscribeEvent
    public static void register(FMLCommonSetupEvent event) {
        SarosRoadBlocksModMod.addNetworkMessage(C2SClick.class, RoadPlannerPackets::encode, RoadPlannerPackets::decode, RoadPlannerPackets::handle);
        SarosRoadBlocksModMod.addNetworkMessage(S2CSyncWaypoints.class, RoadPlannerPackets::encodeSync, RoadPlannerPackets::decodeSync, RoadPlannerPackets::handleSync);
        SarosRoadBlocksModMod.addNetworkMessage(C2SSetWidth.class, RoadPlannerPackets::encodeWidth, RoadPlannerPackets::decodeWidth, RoadPlannerPackets::handleWidth);
        if (((Boolean)ModConfigs.DEBUG_ROAD_PLANNER.get()).booleanValue()) {
            SarosRoadBlocksModMod.LOGGER.info("[RoadPlannerNet] registered C2SClick, S2CSyncWaypoints, C2SSetWidth packets");
        }
    }

    public static class C2SClick {
        public final Action action;
        public final BlockPos pos;

        public C2SClick(Action action, BlockPos pos) {
            this.action = action;
            this.pos = pos;
        }

        public static enum Action {
            ADD,
            CLEAR,
            BUILD,
            REMOVE;

        }
    }

    public static class S2CSyncWaypoints {
        public final List<BlockPos> points;

        public S2CSyncWaypoints(List<BlockPos> pts) {
            this.points = pts;
        }
    }

    public static class C2SSetWidth {
        public final int width;

        public C2SSetWidth(int width) {
            this.width = width;
        }
    }
}

