/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.sarocesch.sarosroadblocksmod.init.SarosRoadBlocksModModItems;
import de.sarocesch.sarosroadblocksmod.item.RoadPlannerItem;
import de.sarocesch.sarosroadblocksmod.road.CurveUtil;
import de.sarocesch.sarosroadblocksmod.road.VecUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RoadPlannerClientRender {
    private static final int GREEN = -16711936;
    private static final int BLUE = -16776961;
    private static final int RED = -65536;
    private static List<BlockPos> clientWaypoints = new ArrayList<BlockPos>();

    public static void setClientWaypoints(List<BlockPos> list) {
        clientWaypoints = list;
    }

    public static BlockPos findNearestWaypoint(BlockPos center, double radius) {
        if (clientWaypoints == null || clientWaypoints.isEmpty() || center == null) {
            return null;
        }
        double r2 = radius * radius;
        BlockPos best = null;
        double bestD2 = Double.MAX_VALUE;
        for (BlockPos bp : clientWaypoints) {
            double dz;
            double dy;
            double dx = bp.m_123341_() - center.m_123341_();
            double d2 = dx * dx + (dy = (double)(bp.m_123342_() - center.m_123342_())) * dy + (dz = (double)(bp.m_123343_() - center.m_123343_())) * dz;
            if (!(d2 <= r2) || !(d2 < bestD2)) continue;
            bestD2 = d2;
            best = bp;
        }
        return best;
    }

    public static BlockPos findNearestWaypointByRay(double maxDist, double radius) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || clientWaypoints == null || clientWaypoints.isEmpty()) {
            return null;
        }
        Vec3 o = mc.f_91063_.m_109153_().m_90583_();
        Vec3 d = mc.f_91074_.m_20154_();
        if (d == null) {
            return null;
        }
        double r2 = radius * radius;
        double bestT = Double.MAX_VALUE;
        BlockPos best = null;
        for (BlockPos bp : clientWaypoints) {
            Vec3 c;
            double dist2;
            Vec3 p = new Vec3((double)bp.m_123341_() + 0.5, (double)bp.m_123342_() + 1.0, (double)bp.m_123343_() + 0.5);
            Vec3 op = p.m_82546_(o);
            double t = op.m_82526_(d);
            if (t < 0.0) {
                t = 0.0;
            } else if (t > maxDist) {
                t = maxDist;
            }
            if (!((dist2 = p.m_82557_(c = o.m_82549_(d.m_82490_(t)))) <= r2) || !(t < bestT)) continue;
            bestT = t;
            best = bp;
        }
        return best;
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        ItemStack held = player.m_21205_();
        if (held.m_41619_() || held.m_41720_() != SarosRoadBlocksModModItems.ROAD_PLANNER.get()) {
            return;
        }
        PoseStack pose = event.getPoseStack();
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        VertexConsumer vc = buffer.m_6299_(RenderType.m_110504_());
        double camX = mc.f_91063_.m_109153_().m_90583_().f_82479_;
        double camY = mc.f_91063_.m_109153_().m_90583_().f_82480_;
        double camZ = mc.f_91063_.m_109153_().m_90583_().f_82481_;
        pose.m_85836_();
        pose.m_85837_(-camX, -camY, -camZ);
        int width = RoadPlannerItem.getWidth(held);
        BlockPos hovered = RoadPlannerClientRender.findNearestWaypointByRay(10.0, 0.75);
        for (BlockPos bp : clientWaypoints) {
            RoadPlannerClientRender.renderBox(vc, pose, bp, hovered != null && hovered.equals((Object)bp) ? -65536 : -16711936);
        }
        List<Vec3> center = CurveUtil.sampleCatmullRomVec(clientWaypoints);
        ArrayList<List<Object>> lines = new ArrayList<List<Object>>();
        lines.add(center);
        ArrayList<Double> offsets = new ArrayList<Double>();
        if (width % 2 == 1) {
            void var19_18;
            half = width / 2;
            int n = -half;
            while (var19_18 <= half) {
                if (var19_18 != false) {
                    offsets.add((double)var19_18);
                }
                ++var19_18;
            }
        } else {
            void var19_22;
            void var19_20;
            half = width / 2;
            int n = -half;
            while (var19_20 < 0) {
                offsets.add((double)var19_20 - 0.5);
                ++var19_20;
            }
            boolean bl = false;
            while (var19_22 < half) {
                offsets.add((double)var19_22 + 0.5);
                ++var19_22;
            }
        }
        Iterator iterator = offsets.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            ArrayList<Vec3> poly = new ArrayList<Vec3>();
            for (int i = 0; i < center.size(); ++i) {
                Vec3 c = center.get(i);
                Vec3 next = i + 1 < center.size() ? center.get(i + 1) : c;
                Vec3 dir = next.m_82546_(c);
                Vec3 normal = VecUtil.normal2D(dir);
                poly.add(c.m_82549_(normal.m_82490_(d)));
            }
            lines.add(poly);
        }
        for (List list : lines) {
            for (int i = 0; i < list.size() - 1; ++i) {
                Vec3 a = (Vec3)list.get(i);
                Vec3 b = (Vec3)list.get(i + 1);
                RoadPlannerClientRender.line(vc, pose, (float)a.f_82479_, (float)a.f_82480_, (float)a.f_82481_, (float)b.f_82479_, (float)b.f_82480_, (float)b.f_82481_, -16776961);
            }
        }
        pose.m_85849_();
        buffer.m_109912_(RenderType.m_110504_());
    }

    private static void renderBox(VertexConsumer vc, PoseStack pose, BlockPos pos, int argb) {
        float x = (float)pos.m_123341_() + 0.5f;
        float y = (float)pos.m_123342_() + 1.0f;
        float z = (float)pos.m_123343_() + 0.5f;
        float size = 0.4f;
        RoadPlannerClientRender.line(vc, pose, x - size, y, z, x + size, y, z, argb);
        RoadPlannerClientRender.line(vc, pose, x, y - size, z, x, y + size, z, argb);
        RoadPlannerClientRender.line(vc, pose, x, y, z - size, x, y, z + size, argb);
        float boxSize = 0.3f;
        RoadPlannerClientRender.line(vc, pose, x - boxSize, y - boxSize, z - boxSize, x + boxSize, y - boxSize, z - boxSize, argb);
        RoadPlannerClientRender.line(vc, pose, x + boxSize, y - boxSize, z - boxSize, x + boxSize, y - boxSize, z + boxSize, argb);
        RoadPlannerClientRender.line(vc, pose, x + boxSize, y - boxSize, z + boxSize, x - boxSize, y - boxSize, z + boxSize, argb);
        RoadPlannerClientRender.line(vc, pose, x - boxSize, y - boxSize, z + boxSize, x - boxSize, y - boxSize, z - boxSize, argb);
        RoadPlannerClientRender.line(vc, pose, x - boxSize, y + boxSize, z - boxSize, x + boxSize, y + boxSize, z - boxSize, argb);
        RoadPlannerClientRender.line(vc, pose, x + boxSize, y + boxSize, z - boxSize, x + boxSize, y + boxSize, z + boxSize, argb);
        RoadPlannerClientRender.line(vc, pose, x + boxSize, y + boxSize, z + boxSize, x - boxSize, y + boxSize, z + boxSize, argb);
        RoadPlannerClientRender.line(vc, pose, x - boxSize, y + boxSize, z + boxSize, x - boxSize, y + boxSize, z - boxSize, argb);
        RoadPlannerClientRender.line(vc, pose, x - boxSize, y - boxSize, z - boxSize, x - boxSize, y + boxSize, z - boxSize, argb);
        RoadPlannerClientRender.line(vc, pose, x + boxSize, y - boxSize, z - boxSize, x + boxSize, y + boxSize, z - boxSize, argb);
        RoadPlannerClientRender.line(vc, pose, x + boxSize, y - boxSize, z + boxSize, x + boxSize, y + boxSize, z + boxSize, argb);
        RoadPlannerClientRender.line(vc, pose, x - boxSize, y - boxSize, z + boxSize, x - boxSize, y + boxSize, z + boxSize, argb);
    }

    private static void renderLine(VertexConsumer vc, PoseStack pose, BlockPos a, BlockPos b, int argb) {
        float x1 = (float)a.m_123341_() + 0.5f;
        float y1 = (float)a.m_123342_() + 1.0f;
        float z1 = (float)a.m_123343_() + 0.5f;
        float x2 = (float)b.m_123341_() + 0.5f;
        float y2 = (float)b.m_123342_() + 1.0f;
        float z2 = (float)b.m_123343_() + 0.5f;
        RoadPlannerClientRender.line(vc, pose, x1, y1, z1, x2, y2, z2, argb);
    }

    private static void line(VertexConsumer vc, PoseStack pose, float x1, float y1, float z1, float x2, float y2, float z2, int argb) {
        float a = (float)(argb >> 24 & 0xFF) / 255.0f;
        float r = (float)(argb >> 16 & 0xFF) / 255.0f;
        float g = (float)(argb >> 8 & 0xFF) / 255.0f;
        float b = (float)(argb & 0xFF) / 255.0f;
        vc.m_252986_(pose.m_85850_().m_252922_(), x1, y1, z1).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vc.m_252986_(pose.m_85850_().m_252922_(), x2, y2, z2).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }
}

