/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.event;

import de.sarocesch.sarosroadblocksmod.block.AsphaltBlock;
import de.sarocesch.sarosroadblocksmod.block.FakeSnowSlopeBlock;
import de.sarocesch.sarosroadblocksmod.block.SidewalkBlock;
import de.sarocesch.sarosroadblocksmod.init.SarosRoadBlocksModModBlocks;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="saros_road_blocks_mod")
public class SnowfallHandler {
    private static final Random RANDOM = new Random();
    private static int tickCounter = 0;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (++tickCounter < 20) {
            return;
        }
        tickCounter = 0;
        if (event.getServer() != null) {
            for (ServerLevel level : event.getServer().m_129785_()) {
                if (!level.m_46471_()) continue;
                SnowfallHandler.processSnowfall(level);
            }
        }
    }

    private static void processSnowfall(ServerLevel level) {
        level.m_6907_().forEach(player -> {
            BlockPos playerPos = player.m_20183_();
            for (int i = 0; i < 20; ++i) {
                int x = playerPos.m_123341_() + RANDOM.nextInt(32) - 16;
                int z = playerPos.m_123343_() + RANDOM.nextInt(32) - 16;
                int y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z);
                BlockPos checkPos = new BlockPos(x, y, z);
                Biome biome = (Biome)level.m_204166_(checkPos).m_203334_();
                if (!level.m_46471_() || biome.m_264600_(checkPos) != Biome.Precipitation.SNOW) continue;
                SnowfallHandler.tryPlaceSnow(level, checkPos);
            }
        });
    }

    private static void tryPlaceSnow(ServerLevel level, BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        BlockState blockBelow = level.m_8055_(belowPos);
        if (blockBelow.m_60734_() instanceof AsphaltBlock || blockBelow.m_60734_() instanceof SidewalkBlock) {
            int currentLayers;
            BlockState blockAtPos = level.m_8055_(pos);
            if (blockAtPos.m_60795_()) {
                int offset = SnowfallHandler.calculateOffset(blockBelow);
                BlockState newSnow = (BlockState)((BlockState)((Block)SarosRoadBlocksModModBlocks.FAKE_SNOW_SLOPE.get()).m_49966_().m_61124_((Property)FakeSnowSlopeBlock.f_56581_, (Comparable)Integer.valueOf(1))).m_61124_((Property)FakeSnowSlopeBlock.SURFACE_OFFSET, (Comparable)Integer.valueOf(offset));
                level.m_7731_(pos, newSnow, 3);
            } else if (blockAtPos.m_60734_() instanceof FakeSnowSlopeBlock && (currentLayers = ((Integer)blockAtPos.m_61143_((Property)SnowLayerBlock.f_56581_)).intValue()) < 8 && RANDOM.nextInt(10) == 0) {
                level.m_7731_(pos, (BlockState)blockAtPos.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(currentLayers + 1)), 3);
            }
        }
    }

    private static int calculateOffset(BlockState belowState) {
        int height = 16;
        if (belowState.m_60734_() instanceof AsphaltBlock) {
            v = (AsphaltBlock.Variant)((Object)belowState.m_61143_(AsphaltBlock.VARIANT));
            height = SnowfallHandler.getHeightForVariant(v);
        } else if (belowState.m_60734_() instanceof SidewalkBlock) {
            v = (SidewalkBlock.Variant)((Object)belowState.m_61143_(SidewalkBlock.VARIANT));
            height = SnowfallHandler.getHeightForVariant((SidewalkBlock.Variant)v);
        }
        int offset = 16 - height;
        return Math.max(0, Math.min(15, offset));
    }

    private static int getHeightForVariant(AsphaltBlock.Variant v) {
        return switch (v) {
            case AsphaltBlock.Variant.ONE -> 15;
            case AsphaltBlock.Variant.TWO -> 14;
            case AsphaltBlock.Variant.THREE -> 13;
            case AsphaltBlock.Variant.FOUR -> 12;
            case AsphaltBlock.Variant.FIVE -> 11;
            case AsphaltBlock.Variant.SIX -> 10;
            case AsphaltBlock.Variant.SEVEN -> 9;
            case AsphaltBlock.Variant.EIGHT -> 8;
            case AsphaltBlock.Variant.NINE -> 7;
            case AsphaltBlock.Variant.TEN -> 6;
            case AsphaltBlock.Variant.ELEVEN -> 5;
            case AsphaltBlock.Variant.TWELVE -> 4;
            case AsphaltBlock.Variant.THIRTEEN -> 3;
            case AsphaltBlock.Variant.FOURTEEN -> 2;
            case AsphaltBlock.Variant.FIFTEEN -> 1;
            default -> 16;
        };
    }

    private static int getHeightForVariant(SidewalkBlock.Variant v) {
        return switch (v) {
            case SidewalkBlock.Variant.ONE -> 15;
            case SidewalkBlock.Variant.TWO -> 14;
            case SidewalkBlock.Variant.THREE -> 13;
            case SidewalkBlock.Variant.FOUR -> 12;
            case SidewalkBlock.Variant.FIVE -> 11;
            case SidewalkBlock.Variant.SIX -> 10;
            case SidewalkBlock.Variant.SEVEN -> 9;
            case SidewalkBlock.Variant.EIGHT -> 8;
            case SidewalkBlock.Variant.NINE -> 7;
            case SidewalkBlock.Variant.TEN -> 6;
            case SidewalkBlock.Variant.ELEVEN -> 5;
            case SidewalkBlock.Variant.TWELVE -> 4;
            case SidewalkBlock.Variant.THIRTEEN -> 3;
            case SidewalkBlock.Variant.FOURTEEN -> 2;
            case SidewalkBlock.Variant.FIFTEEN -> 1;
            default -> 16;
        };
    }
}

