/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.block;

import de.sarocesch.sarosroadblocksmod.block.AsphaltBlock;
import de.sarocesch.sarosroadblocksmod.block.SidewalkBlock;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GuardRailEndBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final Property<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final IntegerProperty OFFSET_PX = IntegerProperty.create((String)"offset_px", (int)0, (int)14);

    public GuardRailEndBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.METAL).strength(3.0f, 6.0f).requiresCorrectToolForDrops().noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)OFFSET_PX, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VoxelShape base = switch ((Direction)state.getValue(FACING)) {
            case Direction.NORTH -> Shapes.or((VoxelShape)GuardRailEndBlock.box((double)7.0, (double)7.0, (double)5.0, (double)16.0, (double)13.0, (double)8.0), (VoxelShape)GuardRailEndBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0));
            case Direction.EAST -> Shapes.or((VoxelShape)GuardRailEndBlock.box((double)8.0, (double)7.0, (double)7.0, (double)11.0, (double)13.0, (double)16.0), (VoxelShape)GuardRailEndBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0));
            case Direction.WEST -> Shapes.or((VoxelShape)GuardRailEndBlock.box((double)5.0, (double)7.0, (double)0.0, (double)8.0, (double)13.0, (double)9.0), (VoxelShape)GuardRailEndBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0));
            default -> Shapes.or((VoxelShape)GuardRailEndBlock.box((double)0.0, (double)7.0, (double)8.0, (double)9.0, (double)13.0, (double)11.0), (VoxelShape)GuardRailEndBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0));
        };
        int off = (Integer)state.getValue((Property)OFFSET_PX);
        return base.move(0.0, -((double)off / 16.0), 0.0);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, OFFSET_PX});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean water = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        int offset = this.computeOffsetPx((LevelAccessor)context.getLevel(), context.getClickedPos().below());
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water))).setValue((Property)OFFSET_PX, (Comparable)Integer.valueOf(offset));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return this.rotate(state, mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List dropsOriginal = super.getDrops(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((ItemLike)this, 1));
    }

    private int computeOffsetPx(LevelAccessor level, BlockPos belowPos) {
        BlockState below = level.getBlockState(belowPos);
        int h = 16;
        if (below.getBlock() instanceof AsphaltBlock) {
            v = (AsphaltBlock.Variant)((Object)below.getValue(AsphaltBlock.VARIANT));
            h = this.heightFromVariant((AsphaltBlock.Variant)v);
        } else if (below.getBlock() instanceof SidewalkBlock) {
            v = (SidewalkBlock.Variant)((Object)below.getValue(SidewalkBlock.VARIANT));
            h = this.heightFromVariant((SidewalkBlock.Variant)v);
        }
        int off = 16 - h;
        if (off < 0) {
            off = 0;
        }
        if (off > 14) {
            off = 14;
        }
        return off;
    }

    private int heightFromVariant(AsphaltBlock.Variant v) {
        return switch (v) {
            case AsphaltBlock.Variant.ONE -> 15;
            case AsphaltBlock.Variant.TWO -> 14;
            case AsphaltBlock.Variant.THREE -> 13;
            case AsphaltBlock.Variant.FOUR -> 12;
            case AsphaltBlock.Variant.FIVE -> 11;
            case AsphaltBlock.Variant.SIX -> 10;
            case AsphaltBlock.Variant.SEVEN -> 9;
            case AsphaltBlock.Variant.EIGHT -> 8;
            case AsphaltBlock.Variant.NINE -> 7;
            case AsphaltBlock.Variant.TEN -> 6;
            case AsphaltBlock.Variant.ELEVEN -> 5;
            case AsphaltBlock.Variant.TWELVE -> 4;
            case AsphaltBlock.Variant.THIRTEEN -> 3;
            case AsphaltBlock.Variant.FOURTEEN -> 2;
            case AsphaltBlock.Variant.FIFTEEN -> 1;
            default -> 16;
        };
    }

    private int heightFromVariant(SidewalkBlock.Variant v) {
        return switch (v) {
            case SidewalkBlock.Variant.ONE -> 15;
            case SidewalkBlock.Variant.TWO -> 14;
            case SidewalkBlock.Variant.THREE -> 13;
            case SidewalkBlock.Variant.FOUR -> 12;
            case SidewalkBlock.Variant.FIVE -> 11;
            case SidewalkBlock.Variant.SIX -> 10;
            case SidewalkBlock.Variant.SEVEN -> 9;
            case SidewalkBlock.Variant.EIGHT -> 8;
            case SidewalkBlock.Variant.NINE -> 7;
            case SidewalkBlock.Variant.TEN -> 6;
            case SidewalkBlock.Variant.ELEVEN -> 5;
            case SidewalkBlock.Variant.TWELVE -> 4;
            case SidewalkBlock.Variant.THIRTEEN -> 3;
            case SidewalkBlock.Variant.FOURTEEN -> 2;
            case SidewalkBlock.Variant.FIFTEEN -> 1;
            default -> 16;
        };
    }
}

