/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.block;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StreetLightBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final Property<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public StreetLightBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.METAL).strength(3.0f, 6.0f).requiresCorrectToolForDrops().lightLevel(s -> 15).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            case Direction.NORTH -> Shapes.or((VoxelShape)StreetLightBlock.box((double)7.0, (double)0.0, (double)14.2, (double)9.0, (double)9.0, (double)16.05), (VoxelShape)StreetLightBlock.box((double)6.5, (double)10.25, (double)-1.25, (double)9.5, (double)12.0, (double)9.25));
            case Direction.EAST -> Shapes.or((VoxelShape)StreetLightBlock.box((double)-0.05, (double)0.0, (double)7.0, (double)1.8, (double)9.0, (double)9.0), (VoxelShape)StreetLightBlock.box((double)6.75, (double)10.25, (double)6.5, (double)17.25, (double)12.0, (double)9.5));
            case Direction.WEST -> Shapes.or((VoxelShape)StreetLightBlock.box((double)14.2, (double)0.0, (double)7.0, (double)16.05, (double)9.0, (double)9.0), (VoxelShape)StreetLightBlock.box((double)-1.25, (double)10.25, (double)6.5, (double)9.25, (double)12.0, (double)9.5));
            default -> Shapes.or((VoxelShape)StreetLightBlock.box((double)7.0, (double)0.0, (double)-0.05, (double)9.0, (double)9.0, (double)1.8), (VoxelShape)StreetLightBlock.box((double)6.5, (double)10.25, (double)6.75, (double)9.5, (double)12.0, (double)17.25));
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return this.rotate(state, mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List dropsOriginal = super.getDrops(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((ItemLike)this, 1));
    }
}

