/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.item;

import de.sarocesch.sarosroadblocksmod.config.ModConfigs;
import de.sarocesch.sarosroadblocksmod.init.SarosRoadBlocksModModDataComponents;
import de.sarocesch.sarosroadblocksmod.road.RoadPlannerManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class RoadPlannerItem
extends Item {
    public static final String NBT_WIDTH = "width";
    public static final int MIN_WIDTH = 3;
    public static final int MAX_WIDTH = 35;
    public static final int DEFAULT_WIDTH = 5;

    public RoadPlannerItem(Item.Properties properties) {
        super(properties.stacksTo(1).rarity(Rarity.UNCOMMON));
    }

    public static int getWidth(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return 5;
        }
        int w = (Integer)stack.getOrDefault((DataComponentType)SarosRoadBlocksModModDataComponents.ROAD_WIDTH.get(), (Object)5);
        if (w <= 0) {
            w = 5;
        }
        return Math.max(3, Math.min(35, w));
    }

    public static void setWidth(ItemStack stack, int width) {
        if (stack == null || stack.isEmpty()) {
            return;
        }
        int w = Math.max(3, Math.min(35, width));
        stack.set((DataComponentType)SarosRoadBlocksModModDataComponents.ROAD_WIDTH.get(), (Object)w);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        Player player = ctx.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockPos pos = ctx.getClickedPos();
        int targetY = (int)Math.floor(ctx.getClickLocation().y);
        pos = new BlockPos(pos.getX(), targetY, pos.getZ());
        if (player.isShiftKeyDown()) {
            if (!level.isClientSide()) {
                RoadPlannerManager.clearWaypoints(level, player);
            }
            return InteractionResult.SUCCESS;
        }
        if (!level.isClientSide()) {
            if (RoadPlannerManager.isExistingWaypoint(level, player, pos)) {
                boolean built = RoadPlannerManager.buildPlannedRoad(level, player);
                if (!built && ((Boolean)ModConfigs.DEBUG_ROAD_PLANNER.get()).booleanValue()) {
                    player.displayClientMessage((Component)Component.literal((String)"No road built: need at least 2 waypoints"), true);
                }
            } else {
                RoadPlannerManager.addWaypoint(level, player, pos);
            }
        }
        return InteractionResult.SUCCESS;
    }
}

