/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.procedures;

import de.sarocesch.sarosroadblocksmod.block.AsphaltBlock;
import de.sarocesch.sarosroadblocksmod.block.SidewalkBlock;
import de.sarocesch.sarosroadblocksmod.init.SarosRoadBlocksModModBlocks;
import de.sarocesch.sarosroadblocksmod.util.RoadTextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class FillingToolRightclickedOnBlockProcedure {
    public static void execute(Level world, double x, double y, double z, Player player) {
        BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() instanceof AsphaltBlock) {
            FillingToolRightclickedOnBlockProcedure.handleAsphalt(world, pos, state, player);
        } else if (state.getBlock() instanceof SidewalkBlock) {
            FillingToolRightclickedOnBlockProcedure.handleSidewalk(world, pos, state, player);
        }
    }

    private static void handleAsphalt(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos abovePos;
        BlockState aboveState;
        AsphaltBlock.Variant nextVariant;
        AsphaltBlock.Variant currentVariant = (AsphaltBlock.Variant)((Object)state.getValue(AsphaltBlock.VARIANT));
        Direction currentFacing = (Direction)state.getValue(AsphaltBlock.FACING);
        switch (currentVariant) {
            default: {
                throw new MatchException(null, null);
            }
            case FIFTEEN: {
                AsphaltBlock.Variant variant = AsphaltBlock.Variant.FOURTEEN;
                break;
            }
            case FOURTEEN: {
                AsphaltBlock.Variant variant = AsphaltBlock.Variant.THIRTEEN;
                break;
            }
            case THIRTEEN: {
                AsphaltBlock.Variant variant = AsphaltBlock.Variant.TWELVE;
                break;
            }
            case TWELVE: {
                AsphaltBlock.Variant variant = AsphaltBlock.Variant.ELEVEN;
                break;
            }
            case ELEVEN: {
                AsphaltBlock.Variant variant = AsphaltBlock.Variant.TEN;
                break;
            }
            case TEN: {
                AsphaltBlock.Variant variant = AsphaltBlock.Variant.NINE;
                break;
            }
            case NINE: {
                AsphaltBlock.Variant variant = AsphaltBlock.Variant.EIGHT;
                break;
            }
            case EIGHT: {
                AsphaltBlock.Variant variant = AsphaltBlock.Variant.SEVEN;
                break;
            }
            case SEVEN: {
                AsphaltBlock.Variant variant = AsphaltBlock.Variant.SIX;
                break;
            }
            case SIX: {
                AsphaltBlock.Variant variant = AsphaltBlock.Variant.FIVE;
                break;
            }
            case FIVE: {
                AsphaltBlock.Variant variant = AsphaltBlock.Variant.FOUR;
                break;
            }
            case FOUR: {
                AsphaltBlock.Variant variant = AsphaltBlock.Variant.THREE;
                break;
            }
            case THREE: {
                AsphaltBlock.Variant variant = AsphaltBlock.Variant.TWO;
                break;
            }
            case TWO: {
                AsphaltBlock.Variant variant = AsphaltBlock.Variant.ONE;
                break;
            }
            case ONE: {
                AsphaltBlock.Variant variant = AsphaltBlock.Variant.DEFAULT;
                break;
            }
            case DEFAULT: {
                AsphaltBlock.Variant variant = nextVariant = AsphaltBlock.Variant.DEFAULT;
            }
        }
        if (currentVariant != nextVariant) {
            String currentTexture = RoadTextureManager.getTextureForBlock(world, pos);
            BlockState newState = (BlockState)((BlockState)state.setValue(AsphaltBlock.VARIANT, (Comparable)((Object)nextVariant))).setValue(AsphaltBlock.FACING, (Comparable)currentFacing);
            world.setBlock(pos, newState, 3);
            if (currentTexture != null && !currentTexture.isEmpty()) {
                RoadTextureManager.setTextureForBlock(world, pos, currentTexture);
            }
            world.playSound(null, pos, SoundEvents.ANVIL_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (nextVariant == AsphaltBlock.Variant.DEFAULT && (aboveState = world.getBlockState(abovePos = pos.above())).isAir()) {
            if (player.isCreative() || player.getInventory().contains(new ItemStack((ItemLike)((Block)SarosRoadBlocksModModBlocks.ASPHALT.get()).asItem()))) {
                String currentTexture = RoadTextureManager.getTextureForBlock(world, pos);
                BlockState newAboveState = (BlockState)((BlockState)((BlockState)((Block)SarosRoadBlocksModModBlocks.ASPHALT.get()).defaultBlockState().setValue(AsphaltBlock.VARIANT, (Comparable)((Object)AsphaltBlock.Variant.FIFTEEN))).setValue(AsphaltBlock.TEXTURE_VARIANT, (Comparable)((Object)((AsphaltBlock.TextureVariant)((Object)state.getValue(AsphaltBlock.TEXTURE_VARIANT)))))).setValue(AsphaltBlock.FACING, (Comparable)currentFacing);
                world.setBlock(abovePos, newAboveState, 3);
                if (currentTexture != null && !currentTexture.isEmpty()) {
                    RoadTextureManager.setTextureForBlock(world, abovePos, currentTexture);
                }
                world.playSound(null, abovePos, SoundEvents.ANVIL_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.isCreative()) {
                    for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                        ItemStack stack = player.getInventory().getItem(i);
                        if (stack.getItem() != ((Block)SarosRoadBlocksModModBlocks.ASPHALT.get()).asItem()) continue;
                        stack.shrink(1);
                        break;
                    }
                }
            } else {
                player.displayClientMessage((Component)Component.literal((String)"\u00a74You need an Asphalt block!"), false);
            }
        }
    }

    private static void handleSidewalk(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos abovePos;
        BlockState aboveState;
        SidewalkBlock.Variant nextVariant;
        SidewalkBlock.Variant currentVariant = (SidewalkBlock.Variant)((Object)state.getValue(SidewalkBlock.VARIANT));
        Direction currentFacing = (Direction)state.getValue(SidewalkBlock.FACING);
        switch (currentVariant) {
            default: {
                throw new MatchException(null, null);
            }
            case FIFTEEN: {
                SidewalkBlock.Variant variant = SidewalkBlock.Variant.FOURTEEN;
                break;
            }
            case FOURTEEN: {
                SidewalkBlock.Variant variant = SidewalkBlock.Variant.THIRTEEN;
                break;
            }
            case THIRTEEN: {
                SidewalkBlock.Variant variant = SidewalkBlock.Variant.TWELVE;
                break;
            }
            case TWELVE: {
                SidewalkBlock.Variant variant = SidewalkBlock.Variant.ELEVEN;
                break;
            }
            case ELEVEN: {
                SidewalkBlock.Variant variant = SidewalkBlock.Variant.TEN;
                break;
            }
            case TEN: {
                SidewalkBlock.Variant variant = SidewalkBlock.Variant.NINE;
                break;
            }
            case NINE: {
                SidewalkBlock.Variant variant = SidewalkBlock.Variant.EIGHT;
                break;
            }
            case EIGHT: {
                SidewalkBlock.Variant variant = SidewalkBlock.Variant.SEVEN;
                break;
            }
            case SEVEN: {
                SidewalkBlock.Variant variant = SidewalkBlock.Variant.SIX;
                break;
            }
            case SIX: {
                SidewalkBlock.Variant variant = SidewalkBlock.Variant.FIVE;
                break;
            }
            case FIVE: {
                SidewalkBlock.Variant variant = SidewalkBlock.Variant.FOUR;
                break;
            }
            case FOUR: {
                SidewalkBlock.Variant variant = SidewalkBlock.Variant.THREE;
                break;
            }
            case THREE: {
                SidewalkBlock.Variant variant = SidewalkBlock.Variant.TWO;
                break;
            }
            case TWO: {
                SidewalkBlock.Variant variant = SidewalkBlock.Variant.ONE;
                break;
            }
            case ONE: {
                SidewalkBlock.Variant variant = SidewalkBlock.Variant.DEFAULT;
                break;
            }
            case DEFAULT: {
                SidewalkBlock.Variant variant = nextVariant = SidewalkBlock.Variant.DEFAULT;
            }
        }
        if (currentVariant != nextVariant) {
            BlockState newState = (BlockState)((BlockState)state.setValue(SidewalkBlock.VARIANT, (Comparable)((Object)nextVariant))).setValue(SidewalkBlock.FACING, (Comparable)currentFacing);
            world.setBlock(pos, newState, 3);
            world.playSound(null, pos, SoundEvents.ANVIL_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (nextVariant == SidewalkBlock.Variant.DEFAULT && (aboveState = world.getBlockState(abovePos = pos.above())).isAir()) {
            if (player.isCreative() || player.getInventory().contains(new ItemStack((ItemLike)((Block)SarosRoadBlocksModModBlocks.SIDEWALK.get()).asItem()))) {
                BlockState newAboveState = (BlockState)((BlockState)((Block)SarosRoadBlocksModModBlocks.SIDEWALK.get()).defaultBlockState().setValue(SidewalkBlock.VARIANT, (Comparable)((Object)SidewalkBlock.Variant.FIFTEEN))).setValue(SidewalkBlock.FACING, (Comparable)currentFacing);
                world.setBlock(abovePos, newAboveState, 3);
                world.playSound(null, abovePos, SoundEvents.ANVIL_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.isCreative()) {
                    for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                        ItemStack stack = player.getInventory().getItem(i);
                        if (stack.getItem() != ((Block)SarosRoadBlocksModModBlocks.SIDEWALK.get()).asItem()) continue;
                        stack.shrink(1);
                        break;
                    }
                }
            } else {
                player.displayClientMessage((Component)Component.literal((String)"\u00a74You need a Sidewalk block!"), false);
            }
        }
    }
}

