/*
 * Decompiled with CFR 0.152.
 */
package com.example.fabrictps;

import com.example.fabrictps.ModConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.server.MinecraftServer;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class FabricTpsNotifierMod
implements DedicatedServerModInitializer {
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "fabrictps_config.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private ModConfig config;
    private AtomicInteger tickCount = new AtomicInteger(0);
    private long lastTime = System.currentTimeMillis();
    private long lastNotificationTime = 0L;
    private final OkHttpClient httpClient = new OkHttpClient();
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");

    public void onInitializeServer() {
        this.loadOrCreateConfig();
        ServerTickEvents.END_SERVER_TICK.register(server -> this.onServerTick(server));
    }

    private void onServerTick(MinecraftServer server) {
        int ticks = this.tickCount.incrementAndGet();
        if (ticks >= 100) {
            long nowMs;
            long now = System.currentTimeMillis();
            long deltaMs = now - this.lastTime;
            double tps = (double)ticks / ((double)deltaMs / 1000.0);
            this.tickCount.set(0);
            this.lastTime = now;
            if (tps < this.config.tpsThreshold && ((nowMs = System.currentTimeMillis()) - this.lastNotificationTime) / 1000L >= this.config.cooldownSeconds) {
                this.sendDiscordMessage(String.format(this.config.message, tps));
                this.lastNotificationTime = nowMs;
            }
        }
    }

    private void loadOrCreateConfig() {
        if (CONFIG_FILE.exists()) {
            try (FileReader fr = new FileReader(CONFIG_FILE);){
                this.config = (ModConfig)GSON.fromJson((Reader)fr, ModConfig.class);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.config = ModConfig.defaultConfig();
            }
        } else {
            this.config = ModConfig.defaultConfig();
            try (FileWriter fw = new FileWriter(CONFIG_FILE);){
                fw.write(GSON.toJson((Object)this.config));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void sendDiscordMessage(String content) {
        if (this.config.botToken == null || this.config.channelId == null || this.config.botToken.isEmpty() || this.config.channelId.isEmpty()) {
            return;
        }
        String url = "https://discord.com/api/v9/channels/" + this.config.channelId + "/messages";
        String payload = GSON.toJson((Object)new DiscordMessage(content));
        RequestBody body = RequestBody.create((MediaType)JSON, (String)payload);
        Request request = new Request.Builder().url(url).header("Authorization", "Bot " + this.config.botToken).header("User-Agent", "Fabric-TPS-Notifier (github.com/example)").post(body).build();
        for (int attempt = 1; attempt <= 2; ++attempt) {
            try (Response response = this.httpClient.newCall(request).execute();){
                if (response.isSuccessful()) break;
                System.err.println("Discord message failed (attempt " + attempt + "): " + response.code() + " - " + response.message());
                if (attempt != 2) continue;
                String respBody = response.body() != null ? response.body().string() : "";
                System.err.println("Discord response body: " + respBody);
                continue;
            }
            catch (Exception e) {
                System.err.println("Error sending Discord message (attempt " + attempt + ") at " + String.valueOf(Instant.now()) + ": " + e.getMessage());
                if (attempt != 2) continue;
                e.printStackTrace();
            }
        }
    }

    static class DiscordMessage {
        final String content;

        DiscordMessage(String content) {
            this.content = content;
        }
    }
}

