/*
 * Decompiled with CFR 0.152.
 */
package com.mars.firearrows.mixin;

import com.mars.firearrows.FireArrowsConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractArrow.class})
public abstract class AbstractArrowMixin
extends Projectile {
    AbstractArrowMixin(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="TAIL")}, method={"onHitBlock"})
    public void onHitBlock(BlockHitResult BHR, CallbackInfo ci) {
        if (BHR.getType() == HitResult.Type.MISS) {
            return;
        }
        if (!this.isOnFire()) {
            return;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            switch (BHR.getDirection()) {
                case UP: {
                    this.startFire(BHR.getBlockPos().above(), level);
                    break;
                }
                case DOWN: {
                    this.startFire(BHR.getBlockPos().below(), level);
                    break;
                }
                case EAST: {
                    this.startFire(BHR.getBlockPos().east(), level);
                    break;
                }
                case WEST: {
                    this.startFire(BHR.getBlockPos().west(), level);
                    break;
                }
                case NORTH: {
                    this.startFire(BHR.getBlockPos().north(), level);
                    break;
                }
                case SOUTH: {
                    this.startFire(BHR.getBlockPos().south(), level);
                }
            }
        }
    }

    public void startFire(BlockPos firePosition, Level level) {
        Block blockInLevel = level.getBlockState(firePosition).getBlock();
        for (int i = 0; i < FireArrowsConfig.blocksBrokenByFireArrows.size(); ++i) {
            if (!blockInLevel.equals(BuiltInRegistries.BLOCK.getValue(ResourceLocation.parse((String)FireArrowsConfig.blocksBrokenByFireArrows.get(i))))) continue;
            level.destroyBlock(firePosition, true);
            level.setBlock(firePosition, BaseFireBlock.getState((BlockGetter)level, (BlockPos)firePosition), 11);
        }
    }
}

