package io.github.yunivers.regui.gui.hud.widget;

import io.github.yunivers.regui.event.HudWidgetRenderEvent;
import io.github.yunivers.regui.util.EHudDock;
import io.github.yunivers.regui.util.EHudPriority;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_564;
import net.minecraft.class_588;
import org.lwjgl.opengl.GL11;

@Environment(EnvType.CLIENT)
public class CrosshairWidget extends HudWidget
{
    public CrosshairWidget()
    {
        super(EHudDock.CENTER);
        this.priority = EHudPriority.HIGH;
        this.baseWidth = this.baseHeight = 16;
    }

    @Override
    public void render(class_588 hud, float tickDelta, class_564 scaler, int xOffset, int yOffset, HudWidget prevWidget)
    {
        super.render(hud, tickDelta, scaler, xOffset, yOffset, prevWidget);
        HudWidgetRenderEvent eResult = this.renderEvent(0); // Pre-Render
        if (eResult.cancelNextRender)
            return;
        int width = scaler.method_1857();
        int height = scaler.method_1858();
        this.field_2522 = -90.0F;

        GL11.glBindTexture(3553, hud.field_2547.field_2814.method_1100("/gui/icons.png"));
        GL11.glEnable(3042);
        GL11.glBlendFunc(775, 769);
        eResult = this.renderEvent(1); // Pre-Render (Actual)
        if (!eResult.cancelNextRender)
            this.method_1936(width / 2 - 7 + eResult.offsetX, height / 2 - 7 + eResult.offsetY, 0, 0, 16, 16);
        this.renderEvent(2); // Post-Render
        GL11.glDisable(3042);
        GL11.glBlendFunc(770, 771);
        this.renderEvent(3); // EOF
    }
}
