package io.github.yunivers.regui.gui.hud.widget;

import io.github.yunivers.regui.event.HudWidgetRenderEvent;
import io.github.yunivers.regui.gui.hud.widget.debug.DebugModule;
import io.github.yunivers.regui.util.EHudDock;
import io.github.yunivers.regui.util.EHudPriority;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_564;
import net.minecraft.class_588;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

import java.lang.reflect.Method;
import java.util.ArrayList;

@Environment(EnvType.CLIENT)
public class DebugWidget extends HudWidget
{
    public static ArrayList<DebugModule> leftModules = new ArrayList<>();
    public static ArrayList<DebugModule> rightModules = new ArrayList<>();
    public boolean betterf3$previousDebugHudValue = false;

    public DebugWidget()
    {
        super(EHudDock.CENTER);
        priority = EHudPriority.LOWEST;
    }

    @Override
    public void render(class_588 hud, float tickDelta, class_564 scaler, int xOffset, int yOffset, HudWidget prevWidget)
    {
        super.render(hud, tickDelta, scaler, xOffset, yOffset, prevWidget);
        HudWidgetRenderEvent eResult = this.renderEvent(0); // Pre-Render
        if (eResult.cancelNextRender)
            return;
        int width = scaler.method_1857();
        this.field_2522 = -90.0F;

        if (FabricLoader.getInstance().isModLoaded("betterf3"))
        {
            if (betterf3$previousDebugHudValue != hud.field_2547.field_2824.field_1443)
            {
                betterf3$previousDebugHudValue = hud.field_2547.field_2824.field_1443;
                ralf2oo2.betterf3.utils.Utils.closingAnimation = !hud.field_2547.field_2824.field_1443;
                if (!ralf2oo2.betterf3.utils.Utils.closingAnimation)
                    ralf2oo2.betterf3.utils.Utils.xPos = 200;
            }

            try
            {
                invokeMethod(hud, "betterf3_renderAnimation");
                if ((hud.field_2547.field_2824.field_1443 && !ralf2oo2.betterf3.config.GeneralOptions.disableMod) ||
                    (ralf2oo2.betterf3.utils.Utils.closingAnimation && !ralf2oo2.betterf3.config.GeneralOptions.disableMod))
                {
                    this.renderEvent(1000); // Pre-Render BetterF3
                    if (!eResult.cancelNextRender)
                    {
                        invokeMethod(hud, "betterf3_renderLeftText");
                        invokeMethod(hud, "betterf3_renderRightText");
                    }
                    this.renderEvent(1001); // Post-Render BetterF3
                    return;
                }
            }
            catch (Exception ignore)
            {

            }
        }

        if (hud.field_2547.field_2824.field_1443)
        {
            GL11.glPushMatrix();
            if (Minecraft.field_2772 > 0L)
                GL11.glTranslatef(0.0F, 32.0F, 0.0F);

            eResult = this.renderEvent(1); // Pre-Render (Actual)
            if (!eResult.cancelNextRender)
            {
                int y = 2;
                for (DebugModule module : leftModules)
                {
                    eResult = this.renderEvent(2, module, y); // Pre-Render Left Module
                    if (!eResult.cancelNextRender)
                    {
                        module.render(hud.field_2547, y + eResult.offsetY, width);
                        y += module.height;
                    }
                    this.renderEvent(3, module, y); // Post-Render Left Module
                }

                y = 2;
                for (DebugModule module : rightModules)
                {
                    eResult = this.renderEvent(4, module, y); // Pre-Render Right Module
                    if (!eResult.cancelNextRender)
                    {
                        module.render(hud.field_2547, y + eResult.offsetY, width);
                        y += module.height;
                    }
                    this.renderEvent(5, module, y); // Post-Render Right Module
                }
            }

            this.renderEvent(6); // Post-Render (Actual)
            GL11.glPopMatrix();
        }
        this.renderEvent(7); // Post-Render/EOF
    }

    // Used to access BetterF3
    public static void invokeMethod(Object instance, String methodName) throws Exception
    {
        Method method = instance.getClass().getDeclaredMethod(methodName);
        method.setAccessible(true);
        method.invoke(instance);
    }
}
