package io.github.yunivers.regui.gui.hud.widget;

import io.github.yunivers.regui.event.HudWidgetRenderEvent;
import io.github.yunivers.regui.util.EHudDock;
import io.github.yunivers.regui.util.EHudPriority;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_564;
import net.minecraft.class_584;
import net.minecraft.class_588;
import net.modificationstation.stationapi.api.StationAPI;

@Environment(EnvType.CLIENT)
public class HudWidget extends class_584
{
    public EHudDock dock;
    public EHudPriority priority = EHudPriority.NORMAL;
    protected int baseWidth;
    protected int baseHeight;
    public int width;
    public int height;

    // For event
    private class_588 hud;
    private float tickDelta;
    private int scaledWidth;
    private int scaledHeight;
    private int offsetX;
    private int offsetY;
    private HudWidget prevWidget;

    public HudWidget(EHudDock dock)
    {
        this.dock = dock;
        this.width = this.height = 0; // uhh idk
    }

    public void render(class_588 hud, float tickDelta, class_564 scaler, int xOffset, int yOffset, HudWidget prevWidget)
    {
        width = baseWidth;
        height = baseHeight;

        this.hud = hud;
        this.tickDelta = tickDelta;
        scaledWidth = scaler.method_1857();
        scaledHeight = scaler.method_1858();
        offsetX = xOffset;
        offsetY = yOffset;
        this.prevWidget = prevWidget;
    }

    protected HudWidgetRenderEvent renderEvent(int stage, Object... args)
    {
        return renderEvent(stage, offsetX, offsetY, args);
    }

    protected HudWidgetRenderEvent renderEvent(int stage, int offsetX, int offsetY, Object[] args)
    {
        HudWidgetRenderEvent event = new HudWidgetRenderEvent(this, stage, args);
        event.setEventData(width, height, offsetX, offsetY, hud, scaledWidth, scaledHeight, tickDelta, prevWidget);
        StationAPI.EVENT_BUS.post(event);
        if (stage == 0)
        {
            width = baseWidth + event.inflateX - event.deflateX;
            height = baseHeight + event.inflateY - event.deflateY;
        }
        return event;
    }
}
