package io.github.yunivers.regui.gui.hud.widget;

import io.github.yunivers.regui.event.HudWidgetRenderEvent;
import io.github.yunivers.regui.util.EHudDock;
import io.github.yunivers.regui.util.EHudPriority;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_34;
import net.minecraft.class_564;
import net.minecraft.class_588;
import org.lwjgl.opengl.GL11;

import java.awt.*;

@Environment(EnvType.CLIENT)
public class JukeboxOverlayWidget extends HudWidget
{
    public JukeboxOverlayWidget()
    {
        super(EHudDock.CENTER);
        priority = EHudPriority.LOWEST;
    }

    @Override
    public void render(class_588 hud, float tickDelta, class_564 scaler, int xOffset, int yOffset, HudWidget prevWidget)
    {
        super.render(hud, tickDelta, scaler, xOffset, yOffset, prevWidget);
        HudWidgetRenderEvent eResult = this.renderEvent(0); // Pre-Render
        if (eResult.cancelNextRender)
            return;
        int width = scaler.method_1857();
        int height = scaler.method_1858();
        this.field_2522 = -90.0F;

        if (hud.field_2550 > 0)
        {
            float overlayRemaining = (float)hud.field_2550 - tickDelta;
            int alpha = Math.min((int)(overlayRemaining * 256.0F / 20.0F), 255);

            if (alpha > 0)
            {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(width / 2), (float)(height - 48), 0.0F);
                GL11.glEnable(3042);
                GL11.glBlendFunc(770, 771);
                int color = 16777215;
                if (hud.field_2551)
                    color = Color.HSBtoRGB(overlayRemaining / 50.0F, 0.7F, 0.6F) & 16777215;

                class_34 textRenderer = hud.field_2547.field_2815;
                eResult = this.renderEvent(1, overlayRemaining, alpha); // Pre-Render (Actual)
                if (!eResult.cancelNextRender)
                    textRenderer.method_1906(hud.field_2549, -textRenderer.method_1901(hud.field_2549) / 2, -4, color + (alpha << 24));
                this.renderEvent(2); // Post-Render
                GL11.glDisable(3042);
                GL11.glPopMatrix();
                this.renderEvent(3); // EOF
            }
        }
    }
}
