package io.github.yunivers.regui.gui.hud.widget;

import io.github.yunivers.regui.event.HudWidgetRenderEvent;
import io.github.yunivers.regui.util.EHudDock;
import io.github.yunivers.regui.util.EHudPriority;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_17;
import net.minecraft.class_564;
import net.minecraft.class_588;
import net.minecraft.class_67;
import net.modificationstation.stationapi.api.client.StationRenderAPI;
import net.modificationstation.stationapi.api.client.texture.Sprite;
import net.modificationstation.stationapi.api.client.texture.atlas.Atlases;
import org.lwjgl.opengl.GL11;

@Environment(EnvType.CLIENT)
public class PortalOverlayWidget extends HudWidget
{
    public PortalOverlayWidget()
    {
        super(EHudDock.CENTER);
        priority = EHudPriority.HIGHEST;
    }

    @Override
    public void render(class_588 hud, float tickDelta, class_564 scaler, int xOffset, int yOffset, HudWidget prevWidget)
    {
        super.render(hud, tickDelta, scaler, xOffset, yOffset, prevWidget);
        HudWidgetRenderEvent eResult = this.renderEvent(0); // Pre-Render
        if (eResult.cancelNextRender)
            return;
        this.width = scaler.method_1857();
        this.height = scaler.method_1858();

        float distortion = hud.field_2547.field_2806.field_505 + (hud.field_2547.field_2806.field_504 - hud.field_2547.field_2806.field_505) * tickDelta;
        if (distortion > 0.0F)
        {
            if (distortion < 1.0F)
            {
                distortion *= distortion;
                distortion *= distortion;
                distortion = distortion * 0.8F + 0.2F;
            }

            GL11.glDisable(3008);
            GL11.glDisable(2929);
            GL11.glDepthMask(false);
            GL11.glBlendFunc(770, 771);
            GL11.glColor4f(1.0F, 1.0F, 1.0F, distortion);

            StationRenderAPI.getBakedModelManager().getAtlas(Atlases.GAME_ATLAS_TEXTURE).bindTexture();
            Sprite sprite = class_17.field_1907.getAtlas().getTexture(class_17.field_1907.field_1914).getSprite();

            eResult = this.renderEvent(1, distortion, sprite); // Pre-Render (Actual)
            if (!eResult.cancelNextRender)
            {
                class_67 t = class_67.field_2054;
                t.method_1695();
                t.method_1688(0,     height, -90, sprite.getMinU(), sprite.getMaxV());
                t.method_1688(width,    height, -90, sprite.getMaxU(), sprite.getMaxV());
                t.method_1688(width, 0,      -90, sprite.getMaxU(), sprite.getMinV());
                t.method_1688(0,  0,      -90, sprite.getMinU(), sprite.getMinV());
                t.method_1685();
            }
            this.renderEvent(2); // Post-Render

            GL11.glDepthMask(true);
            GL11.glEnable(2929);
            GL11.glEnable(3008);
            GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
            this.renderEvent(3); // EOF
        }
    }
}
