package io.github.yunivers.regui.gui.hud.widget;

import io.github.yunivers.regui.event.HudWidgetRenderEvent;
import io.github.yunivers.regui.util.EHudDock;
import io.github.yunivers.regui.util.EHudPriority;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_17;
import net.minecraft.class_31;
import net.minecraft.class_564;
import net.minecraft.class_588;
import net.minecraft.class_67;
import org.lwjgl.opengl.GL11;

@Environment(EnvType.CLIENT)
public class PumpkinOverlayWidget extends HudWidget
{
    public PumpkinOverlayWidget()
    {
        super(EHudDock.CENTER);
        priority = EHudPriority.HIGHEST;
    }

    @Override
    public void render(class_588 hud, float tickDelta, class_564 scaler, int xOffset, int yOffset, HudWidget prevWidget)
    {
        super.render(hud, tickDelta, scaler, xOffset, yOffset, prevWidget);
        HudWidgetRenderEvent eResult = this.renderEvent(0); // Pre-Render
        if (eResult.cancelNextRender)
            return;
        this.width = scaler.method_1857();
        this.height = scaler.method_1858();

        class_31 stack = hud.field_2547.field_2806.field_519.method_693(3);
        if (!hud.field_2547.field_2824.field_1442 && stack != null && stack.field_753 == class_17.field_1903.field_1915)
        {
            GL11.glDisable(2929);
            GL11.glDepthMask(false);
            GL11.glBlendFunc(770, 771);
            GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
            GL11.glDisable(3008);
            GL11.glBindTexture(3553, hud.field_2547.field_2814.method_1100("%blur%/misc/pumpkinblur.png"));
            eResult = this.renderEvent(1); // Pre-Render (Actual)
            if (!eResult.cancelNextRender)
            {
                class_67 var3 = class_67.field_2054;
                var3.method_1695();
                var3.method_1688(0,     height, -90, 0, 1);
                var3.method_1688(width,    height, -90, 1, 1);
                var3.method_1688(width, 0,      -90, 1, 0);
                var3.method_1688(0,  0,      -90, 0, 0);
                var3.method_1685();
            }
            this.renderEvent(2); // Post-Render
            GL11.glDepthMask(true);
            GL11.glEnable(2929);
            GL11.glEnable(3008);
            GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
            this.renderEvent(3); // EOF
        }
    }
}
