package io.github.yunivers.regui.gui.hud.widget;

import io.github.yunivers.regui.event.HudWidgetRenderEvent;
import io.github.yunivers.regui.util.EHudDock;
import io.github.yunivers.regui.util.EHudPriority;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_564;
import net.minecraft.class_588;
import net.minecraft.class_67;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

@Environment(EnvType.CLIENT)
public class VignetteWidget extends HudWidget
{
    public VignetteWidget()
    {
        super(EHudDock.CENTER);
        priority = EHudPriority.HIGHEST;
    }

    @Override
    public void render(class_588 hud, float tickDelta, class_564 scaler, int xOffset, int yOffset, HudWidget prevWidget)
    {
        super.render(hud, tickDelta, scaler, xOffset, yOffset, prevWidget);
        HudWidgetRenderEvent eResult = this.renderEvent(0); // Pre-Render
        if (eResult.cancelNextRender)
            return;
        this.width = scaler.method_1857();
        this.height = scaler.method_1858();

        if (Minecraft.method_2147())
        {
            GL11.glEnable(3042);
            float brightness = MathHelper.clamp(1.0F - hud.field_2547.field_2806.method_1394(tickDelta), 0.0F, 1.0F);

            hud.field_2543 = (float)((double)hud.field_2543 + (double)(brightness - hud.field_2543) * 0.01);
            GL11.glDisable(2929);
            GL11.glDepthMask(false);
            GL11.glBlendFunc(0, 769);
            GL11.glColor4f(hud.field_2543, hud.field_2543, hud.field_2543, 1.0F);
            GL11.glBindTexture(3553, hud.field_2547.field_2814.method_1100("%blur%/misc/vignette.png"));
            eResult = this.renderEvent(1); // Pre-Render (Actual)
            if (!eResult.cancelNextRender)
            {
                class_67 var4 = class_67.field_2054;
                var4.method_1695();
                var4.method_1688(0,     height, -90, 0, 1);
                var4.method_1688(width,    height, -90, 1, 1);
                var4.method_1688(width, 0,      -90, 1, 0);
                var4.method_1688(0,  0,      -90, 0, 0);
                var4.method_1685();
            }
            this.renderEvent(2); // Post-Render
            GL11.glDepthMask(true);
            GL11.glEnable(2929);
            GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
            GL11.glBlendFunc(770, 771);
            this.renderEvent(3); // EOF
        }
    }
}
