package io.github.yunivers.regui.gui.hud.widget.debug;

import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_17;
import net.minecraft.class_212;
import net.minecraft.class_27;
import net.minecraft.class_34;
import net.minecraft.class_55;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.state.property.Property;
import net.modificationstation.stationapi.api.tag.TagKey;

import java.util.Collection;

public class TargetBlockModule extends DebugModule
{
    public TargetBlockModule()
    {
        super();
    }

    @Override
    public void render(Minecraft minecraft, int y, int width)
    {
        class_34 textRenderer = minecraft.field_2815;
        class_27 hit = minecraft.field_2823;
        int offset = y;
        if (hit != null && hit.field_1983 == class_212.field_789)
        {
            BlockState state = minecraft.field_2804.getBlockState(hit.field_1984, hit.field_1985, hit.field_1986);

            String text = "Block: " + state.getBlock().method_1596();
            method_1937(textRenderer, text, width - textRenderer.method_1901(text) - 2, y += 10, 0xFFFFFF);

            text = "Meta: " + minecraft.field_2804.method_1778(hit.field_1984, hit.field_1985, hit.field_1986);
            method_1937(textRenderer, text, width - textRenderer.method_1901(text) - 2, y += 10, 0xFFFFFF);

            Collection<Property<?>> properties = state.getProperties();
            if (!properties.isEmpty())
            {
                text = "Properties:";
                method_1937(textRenderer, text, width - textRenderer.method_1901(text) - 2, y += 10, 0xFFFFFF);

                for (Property<?> property : properties)
                {
                    text = property.getName() + ": " + state.get(property);
                    method_1937(textRenderer, text, width - textRenderer.method_1901(text) - 2, y += 10, 0xE0E0E0);
                }
            }

            Collection<TagKey<class_17>> tags = state.streamTags().toList();
            if (!tags.isEmpty())
            {
                text = "Tags:";
                method_1937(textRenderer, text, width - textRenderer.method_1901(text) - 2, y += 10, 0xFFFFFF);

                for (TagKey<class_17> property : tags)
                {
                    text = "#" + property.id();
                    method_1937(textRenderer, text, width - textRenderer.method_1901(text) - 2, y += 10, 0xE0E0E0);
                }
            }

            if (FabricLoader.getInstance().isDevelopmentEnvironment())
            {
                class_55 entity = minecraft.field_2804.method_1777(hit.field_1984, hit.field_1985, hit.field_1986);
                if (entity != null)
                {
                    String className = entity.getClass().getName();
                    text = "Tile Entity: " + className.substring(className.lastIndexOf('.') + 1);
                    method_1937(textRenderer, text, width - textRenderer.method_1901(text) - 2, y + 20, 0xFFFFFF);
                    y += 20;
                }
            }
        }

        height = y - offset;
    }
}
