/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.v1_21_11to1_21_9;

import com.viaversion.nbt.tag.ByteTag;
import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.IntTag;
import com.viaversion.nbt.tag.ListTag;
import com.viaversion.nbt.tag.NumberTag;
import com.viaversion.nbt.tag.StringTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viabackwards.api.BackwardsProtocol;
import com.viaversion.viabackwards.api.data.BackwardsMappingData;
import com.viaversion.viabackwards.api.rewriters.BackwardsRegistryRewriter;
import com.viaversion.viabackwards.api.rewriters.SoundRewriter;
import com.viaversion.viabackwards.api.rewriters.text.NBTComponentRewriter;
import com.viaversion.viabackwards.protocol.v1_21_11to1_21_9.rewriter.BlockItemPacketRewriter1_21_11;
import com.viaversion.viabackwards.protocol.v1_21_11to1_21_9.rewriter.ComponentRewriter1_21_11;
import com.viaversion.viabackwards.protocol.v1_21_11to1_21_9.rewriter.EntityPacketRewriter1_21_11;
import com.viaversion.viabackwards.protocol.v1_21_11to1_21_9.storage.GameTimeStorage;
import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.data.entity.EntityTracker;
import com.viaversion.viaversion.api.data.item.ItemHasher;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.minecraft.entities.EntityTypes1_21_11;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.provider.PacketTypesProvider;
import com.viaversion.viaversion.api.protocol.packet.provider.SimplePacketTypesProvider;
import com.viaversion.viaversion.api.type.types.version.VersionedTypes;
import com.viaversion.viaversion.api.type.types.version.VersionedTypesHolder;
import com.viaversion.viaversion.data.entity.EntityTrackerBase;
import com.viaversion.viaversion.data.item.ItemHasherBase;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ServerboundPackets1_21_6;
import com.viaversion.viaversion.protocols.v1_21_7to1_21_9.packet.ClientboundConfigurationPackets1_21_9;
import com.viaversion.viaversion.protocols.v1_21_7to1_21_9.packet.ClientboundPacket1_21_9;
import com.viaversion.viaversion.protocols.v1_21_7to1_21_9.packet.ClientboundPackets1_21_9;
import com.viaversion.viaversion.protocols.v1_21_7to1_21_9.packet.ServerboundConfigurationPackets1_21_9;
import com.viaversion.viaversion.protocols.v1_21_7to1_21_9.packet.ServerboundPacket1_21_9;
import com.viaversion.viaversion.protocols.v1_21_9to1_21_11.Protocol1_21_9To1_21_11;
import com.viaversion.viaversion.protocols.v1_21_9to1_21_11.packet.ClientboundPacket1_21_11;
import com.viaversion.viaversion.protocols.v1_21_9to1_21_11.packet.ClientboundPackets1_21_11;
import com.viaversion.viaversion.rewriter.AttributeRewriter;
import com.viaversion.viaversion.rewriter.ParticleRewriter;
import com.viaversion.viaversion.rewriter.RegistryDataRewriter;
import com.viaversion.viaversion.rewriter.StatisticsRewriter;
import com.viaversion.viaversion.rewriter.TagRewriter;
import com.viaversion.viaversion.util.Key;
import com.viaversion.viaversion.util.ProtocolUtil;
import com.viaversion.viaversion.util.TagUtil;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Protocol1_21_11To1_21_9
extends BackwardsProtocol<ClientboundPacket1_21_11, ClientboundPacket1_21_9, ServerboundPacket1_21_9, ServerboundPacket1_21_9> {
    public static final BackwardsMappingData MAPPINGS = new BackwardsMappingData("1.21.11", "1.21.9", Protocol1_21_9To1_21_11.class);
    private static final int END_FOG_COLOR = 0xA080A0;
    private static final int OVERWORLD_FOG_COLOR = 126384063;
    private final EntityPacketRewriter1_21_11 entityRewriter = new EntityPacketRewriter1_21_11(this);
    private final BlockItemPacketRewriter1_21_11 itemRewriter = new BlockItemPacketRewriter1_21_11(this);
    private final ParticleRewriter<ClientboundPacket1_21_11> particleRewriter = new ParticleRewriter((Protocol)this);
    private final NBTComponentRewriter<ClientboundPacket1_21_11> translatableRewriter = new ComponentRewriter1_21_11(this);
    private final TagRewriter<ClientboundPacket1_21_11> tagRewriter = new TagRewriter((Protocol)this);
    private final RegistryDataRewriter registryDataRewriter = new BackwardsRegistryRewriter(this);

    public Protocol1_21_11To1_21_9() {
        super(ClientboundPacket1_21_11.class, ClientboundPacket1_21_9.class, ServerboundPacket1_21_9.class, ServerboundPacket1_21_9.class);
    }

    private void moveAttribute(CompoundTag baseTag, @Nullable CompoundTag attributes, String key, String mappedKey, Function<Tag, Tag> tagMapper, @Nullable Tag defaultTag) {
        Tag attributeTag;
        if (attributes != null && (attributeTag = TagUtil.getNamespacedTag((CompoundTag)attributes, (String)key)) != null) {
            baseTag.put(mappedKey, tagMapper.apply(attributeTag));
        } else if (defaultTag != null) {
            baseTag.put(mappedKey, defaultTag);
        }
    }

    private int floatsToARGB(float r, float g, float b) {
        return 0xFF000000 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
    }

    @Override
    protected void registerPackets() {
        super.registerPackets();
        this.registryDataRewriter.addHandler("dimension_type", (key, tag) -> {
            if (Key.equals((String)key, (String)"the_nether")) {
                tag.putString("effects", "minecraft:the_nether");
                tag.putBoolean("natural", false);
            } else if (Key.equals((String)key, (String)"the_end")) {
                tag.putString("effects", "minecraft:the_end");
                tag.putBoolean("natural", false);
            } else {
                tag.putString("effects", "minecraft:overworld");
                tag.putBoolean("natural", true);
            }
            ByteTag trueTag = new ByteTag(1);
            CompoundTag attributes = tag.getCompoundTag("attributes");
            this.moveAttribute((CompoundTag)tag, attributes, "visual/cloud_height", "cloud_height", Function.identity(), null);
            this.moveAttribute((CompoundTag)tag, attributes, "gameplay/can_start_raid", "has_raids", Function.identity(), (Tag)trueTag);
            this.moveAttribute((CompoundTag)tag, attributes, "gameplay/can_start_raid", "has_raids", Function.identity(), (Tag)trueTag);
            this.moveAttribute((CompoundTag)tag, attributes, "gameplay/piglins_zombify", "piglin_safe", attributeTag -> ((NumberTag)attributeTag).asBoolean() ? ByteTag.ZERO : trueTag, (Tag)ByteTag.ZERO);
            this.moveAttribute((CompoundTag)tag, attributes, "gameplay/respawn_anchor_works", "respawn_anchor_works", Function.identity(), (Tag)trueTag);
            this.moveAttribute((CompoundTag)tag, attributes, "gameplay/bed_rule", "bed_works", attributeTag -> {
                CompoundTag bedRule = (CompoundTag)attributeTag;
                return bedRule.getBoolean("can_sleep") || bedRule.getBoolean("can_set_spawn") ? trueTag : ByteTag.ZERO;
            }, (Tag)trueTag);
            this.moveAttribute((CompoundTag)tag, attributes, "gameplay/fast_lava", "ultrawarm", Function.identity(), (Tag)ByteTag.ZERO);
        });
        this.registryDataRewriter.addHandler("worldgen/biome", (key, tag) -> {
            CompoundTag effects = tag.getCompoundTag("effects");
            CompoundTag attributes = (CompoundTag)tag.removeUnchecked("attributes");
            this.moveAttribute(effects, attributes, "visual/sky_color", "sky_color", this::mapColor, (Tag)new IntTag(0));
            this.moveAttribute(effects, attributes, "visual/water_fog_color", "water_fog_color", this::mapColor, (Tag)new IntTag(-16448205));
            this.moveAttribute(effects, attributes, "visual/fog_color", "fog_color", this::mapColor, (Tag)new IntTag(Key.equals((String)key, (String)"the_end") ? 0xA080A0 : 126384063));
            this.moveAttribute(effects, effects, "water_color", "water_color", this::mapColor, (Tag)new IntTag(4159204));
            this.moveAttribute(effects, effects, "foliage_color", "foliage_color", this::mapColor, null);
            this.moveAttribute(effects, effects, "dry_foliage_color", "dry_foliage_color", this::mapColor, null);
            this.moveAttribute(effects, effects, "grass_color", "grass_color", this::mapColor, null);
        });
        this.registryDataRewriter.addHandler("enchantment", (key, tag) -> {
            CompoundTag effects = tag.getCompoundTag("effects");
            if (effects != null) {
                TagUtil.removeNamespaced((CompoundTag)effects, (String)"post_piercing_attack");
            }
        });
        this.registryDataRewriter.remove("zombie_nautilus_variant");
        this.registryDataRewriter.remove("timeline");
        this.registerClientbound((ClientboundPacketType)ClientboundConfigurationPackets1_21_9.REGISTRY_DATA, arg_0 -> ((RegistryDataRewriter)this.registryDataRewriter).handle(arg_0));
        this.tagRewriter.removeTags("timeline");
        this.tagRewriter.registerGeneric((ClientboundPacketType)ClientboundPackets1_21_11.UPDATE_TAGS);
        this.tagRewriter.registerGeneric((ClientboundPacketType)ClientboundConfigurationPackets1_21_9.UPDATE_TAGS);
        SoundRewriter<ClientboundPacket1_21_11> soundRewriter = new SoundRewriter<ClientboundPacket1_21_11>(this);
        soundRewriter.registerSound1_19_3((ClientboundPacket1_21_11)ClientboundPackets1_21_11.SOUND);
        soundRewriter.registerSound1_19_3((ClientboundPacket1_21_11)ClientboundPackets1_21_11.SOUND_ENTITY);
        soundRewriter.registerStopSound((ClientboundPacket1_21_11)ClientboundPackets1_21_11.STOP_SOUND);
        new StatisticsRewriter((Protocol)this).register((ClientboundPacketType)ClientboundPackets1_21_11.AWARD_STATS);
        new AttributeRewriter((Protocol)this).register1_21((ClientboundPacketType)ClientboundPackets1_21_11.UPDATE_ATTRIBUTES);
        this.translatableRewriter.registerOpenScreen1_14((ClientboundPacketType)ClientboundPackets1_21_11.OPEN_SCREEN);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_21_11.SET_ACTION_BAR_TEXT);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_21_11.SET_TITLE_TEXT);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_21_11.SET_SUBTITLE_TEXT);
        this.translatableRewriter.registerBossEvent((ClientboundPacketType)ClientboundPackets1_21_11.BOSS_EVENT);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_21_11.DISCONNECT);
        this.translatableRewriter.registerTabList((ClientboundPacketType)ClientboundPackets1_21_11.TAB_LIST);
        this.translatableRewriter.registerPlayerCombatKill1_20((ClientboundPacketType)ClientboundPackets1_21_11.PLAYER_COMBAT_KILL);
        this.translatableRewriter.registerPlayerInfoUpdate1_21_4((ClientboundPacketType)ClientboundPackets1_21_11.PLAYER_INFO_UPDATE);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_21_11.SYSTEM_CHAT);
        this.translatableRewriter.registerDisguisedChat((ClientboundPacketType)ClientboundPackets1_21_11.DISGUISED_CHAT);
        this.translatableRewriter.registerPlayerChat1_21_5((ClientboundPacketType)ClientboundPackets1_21_11.PLAYER_CHAT);
        this.translatableRewriter.registerPing();
        this.particleRewriter.registerLevelParticles1_21_4((ClientboundPacketType)ClientboundPackets1_21_11.LEVEL_PARTICLES);
        this.particleRewriter.registerExplode1_21_9((ClientboundPacketType)ClientboundPackets1_21_11.EXPLODE);
    }

    public void init(UserConnection connection) {
        this.addEntityTracker(connection, (EntityTracker)new EntityTrackerBase(connection, (EntityType)EntityTypes1_21_11.PLAYER));
        this.addItemHasher(connection, (ItemHasher)new ItemHasherBase((Protocol)this, connection));
        connection.put((StorableObject)new GameTimeStorage());
    }

    @Override
    public BackwardsMappingData getMappingData() {
        return MAPPINGS;
    }

    public EntityPacketRewriter1_21_11 getEntityRewriter() {
        return this.entityRewriter;
    }

    public BlockItemPacketRewriter1_21_11 getItemRewriter() {
        return this.itemRewriter;
    }

    public RegistryDataRewriter getRegistryDataRewriter() {
        return this.registryDataRewriter;
    }

    public ParticleRewriter<ClientboundPacket1_21_11> getParticleRewriter() {
        return this.particleRewriter;
    }

    @Override
    public NBTComponentRewriter<ClientboundPacket1_21_11> getComponentRewriter() {
        return this.translatableRewriter;
    }

    public TagRewriter<ClientboundPacket1_21_11> getTagRewriter() {
        return this.tagRewriter;
    }

    public VersionedTypesHolder types() {
        return VersionedTypes.V1_21_11;
    }

    public VersionedTypesHolder mappedTypes() {
        return VersionedTypes.V1_21_9;
    }

    protected PacketTypesProvider<ClientboundPacket1_21_11, ClientboundPacket1_21_9, ServerboundPacket1_21_9, ServerboundPacket1_21_9> createPacketTypesProvider() {
        return new SimplePacketTypesProvider(ProtocolUtil.packetTypeMap((Class)this.unmappedClientboundPacketType, (Class[])new Class[]{ClientboundPackets1_21_11.class, ClientboundConfigurationPackets1_21_9.class}), ProtocolUtil.packetTypeMap((Class)this.mappedClientboundPacketType, (Class[])new Class[]{ClientboundPackets1_21_9.class, ClientboundConfigurationPackets1_21_9.class}), ProtocolUtil.packetTypeMap((Class)this.mappedServerboundPacketType, (Class[])new Class[]{ServerboundPackets1_21_6.class, ServerboundConfigurationPackets1_21_9.class}), ProtocolUtil.packetTypeMap((Class)this.unmappedServerboundPacketType, (Class[])new Class[]{ServerboundPackets1_21_6.class, ServerboundConfigurationPackets1_21_9.class}));
    }

    private Tag mapColor(Tag attributeTag) {
        if (attributeTag instanceof ListTag) {
            ListTag listTag = (ListTag)attributeTag;
            NumberTag r = (NumberTag)listTag.get(0);
            NumberTag g = (NumberTag)listTag.get(1);
            NumberTag b = (NumberTag)listTag.get(2);
            return new IntTag(this.floatsToARGB(r.asFloat(), g.asFloat(), b.asFloat()));
        }
        if (attributeTag instanceof StringTag) {
            StringTag stringTag = (StringTag)attributeTag;
            return new IntTag(Integer.parseInt(stringTag.getValue().substring(1), 16));
        }
        return attributeTag;
    }
}

