/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.api.rewriters;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.FloatTag;
import com.viaversion.nbt.tag.IntArrayTag;
import com.viaversion.nbt.tag.IntTag;
import com.viaversion.nbt.tag.ListTag;
import com.viaversion.nbt.tag.StringTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viabackwards.api.BackwardsProtocol;
import com.viaversion.viabackwards.api.data.BackwardsMappingData;
import com.viaversion.viabackwards.api.data.MappedItem;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.EitherHolder;
import com.viaversion.viaversion.api.minecraft.Holder;
import com.viaversion.viaversion.api.minecraft.HolderSet;
import com.viaversion.viaversion.api.minecraft.data.StructuredDataContainer;
import com.viaversion.viaversion.api.minecraft.data.StructuredDataKey;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.minecraft.item.data.CustomModelData1_21_4;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.rewriter.StructuredItemRewriter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BackwardsStructuredItemRewriter<C extends ClientboundPacketType, S extends ServerboundPacketType, T extends BackwardsProtocol<C, ?, ?, S>>
extends StructuredItemRewriter<C, S, T> {
    private static final int[] EMPTY_INT_ARRAY = new int[0];

    public BackwardsStructuredItemRewriter(T protocol, Type<Item> itemType, Type<Item[]> itemArrayType, Type<Item> mappedItemType, Type<Item[]> mappedItemArrayType, Type<Item> itemCostType, Type<Item> optionalItemCostType, Type<Item> mappedItemCostType, Type<Item> mappedOptionalItemCostType) {
        super(protocol, itemType, itemArrayType, mappedItemType, mappedItemArrayType, itemCostType, optionalItemCostType, mappedItemCostType, mappedOptionalItemCostType);
    }

    public BackwardsStructuredItemRewriter(T protocol, Type<Item> itemType, Type<Item[]> itemArrayType, Type<Item> mappedItemType, Type<Item[]> mappedItemArrayType) {
        super(protocol, itemType, itemArrayType, mappedItemType, mappedItemArrayType);
    }

    public BackwardsStructuredItemRewriter(T protocol, Type<Item> itemType, Type<Item[]> itemArrayType) {
        super(protocol, itemType, itemArrayType);
    }

    public Item handleItemToClient(UserConnection connection, Item item) {
        MappedItem mappedItem;
        if (item.isEmpty()) {
            return item;
        }
        StructuredDataContainer dataContainer = item.dataContainer();
        this.updateItemDataComponentTypeIds(dataContainer, true);
        BackwardsMappingData mappingData = ((BackwardsProtocol)this.protocol).getMappingData();
        MappedItem mappedItem2 = mappedItem = mappingData != null ? mappingData.getMappedItem(item.identifier()) : null;
        if (mappedItem == null) {
            if (mappingData != null && mappingData.getItemMappings() != null) {
                item.setIdentifier(mappingData.getNewItemId(item.identifier()));
            }
            this.updateItemDataComponents(connection, item, true);
            return item;
        }
        CompoundTag tag = this.createCustomTag(item);
        tag.putInt(this.nbtTagName("id"), item.identifier());
        item.setIdentifier(mappedItem.id());
        if (mappedItem.customModelData() != null) {
            if (connection.getProtocolInfo().protocolVersion().newerThanOrEqualTo(ProtocolVersion.v1_21_4)) {
                if (!dataContainer.has(StructuredDataKey.CUSTOM_MODEL_DATA1_21_4)) {
                    dataContainer.set(StructuredDataKey.CUSTOM_MODEL_DATA1_21_4, (Object)new CustomModelData1_21_4(new float[]{mappedItem.customModelData().floatValue()}, new boolean[0], new String[0], EMPTY_INT_ARRAY));
                }
            } else if (!dataContainer.has(StructuredDataKey.CUSTOM_MODEL_DATA1_20_5)) {
                dataContainer.set(StructuredDataKey.CUSTOM_MODEL_DATA1_20_5, (Object)mappedItem.customModelData());
            }
        }
        if (!dataContainer.has(StructuredDataKey.CUSTOM_NAME)) {
            dataContainer.set(StructuredDataKey.CUSTOM_NAME, (Object)mappedItem.tagName());
            tag.putBoolean(this.nbtTagName("added_custom_name"), true);
        }
        this.updateItemDataComponents(connection, item, true);
        return item;
    }

    public Item handleItemToServer(UserConnection connection, Item item) {
        Tag tag;
        CompoundTag customData;
        if (item.isEmpty()) {
            return item;
        }
        StructuredDataContainer dataContainer = item.dataContainer();
        this.updateItemDataComponentTypeIds(dataContainer, false);
        BackwardsMappingData mappingData = ((BackwardsProtocol)this.protocol).getMappingData();
        if (mappingData != null && mappingData.getItemMappings() != null) {
            item.setIdentifier(mappingData.getOldItemId(item.identifier()));
        }
        if ((customData = (CompoundTag)dataContainer.get(StructuredDataKey.CUSTOM_DATA)) != null && (tag = customData.remove(this.nbtTagName("id"))) instanceof IntTag) {
            IntTag originalTag = (IntTag)tag;
            item.setIdentifier(originalTag.asInt());
            this.removeCustomTag(dataContainer, customData);
        }
        this.updateItemDataComponents(connection, item, false);
        this.restoreBackupData(item);
        return item;
    }

    protected void saveListTag(CompoundTag tag, ListTag<?> original, String name) {
        String backupName = this.nbtTagName(name);
        if (!tag.contains(backupName)) {
            tag.put(backupName, (Tag)original.copy());
        }
    }

    public <T extends Tag> @Nullable ListTag<T> removeListTag(CompoundTag tag, String tagName, Class<T> tagType) {
        String backupName = this.nbtTagName(tagName);
        ListTag data = tag.getListTag(backupName, tagType);
        if (data == null) {
            return null;
        }
        tag.remove(backupName);
        return data;
    }

    protected void saveGenericTagList(CompoundTag tag, List<Tag> original, String name) {
        String backupName = this.nbtTagName(name);
        if (!tag.contains(backupName)) {
            CompoundTag output = new CompoundTag();
            for (int i = 0; i < original.size(); ++i) {
                output.put(Integer.toString(i), original.get(i));
            }
            tag.put(backupName, (Tag)output);
        }
    }

    protected List<Tag> removeGenericTagList(CompoundTag tag, String name) {
        String backupName = this.nbtTagName(name);
        CompoundTag data = tag.getCompoundTag(backupName);
        if (data == null) {
            return null;
        }
        tag.remove(backupName);
        return new ArrayList<Tag>(data.values());
    }

    protected Tag holderSetToTag(HolderSet set) {
        if (set.hasIds()) {
            return new IntArrayTag(set.ids());
        }
        return new StringTag(set.tagKey());
    }

    protected HolderSet restoreHolderSet(CompoundTag tag, String key) {
        Tag savedTag = tag.get(key);
        if (savedTag == null) {
            return HolderSet.of((int[])EMPTY_INT_ARRAY);
        }
        if (savedTag instanceof StringTag) {
            StringTag tagKey = (StringTag)savedTag;
            return HolderSet.of((String)tagKey.getValue());
        }
        if (savedTag instanceof IntArrayTag) {
            IntArrayTag idsTag = (IntArrayTag)savedTag;
            return HolderSet.of((int[])idsTag.getValue());
        }
        return HolderSet.of((int[])EMPTY_INT_ARRAY);
    }

    protected <V> Tag holderToTag(Holder<V> holder, BiConsumer<V, CompoundTag> valueSaveFunction) {
        if (holder.hasId()) {
            return new IntTag(holder.id());
        }
        CompoundTag savedTag = new CompoundTag();
        valueSaveFunction.accept(holder.value(), savedTag);
        return savedTag;
    }

    protected <V> Tag eitherHolderToTag(EitherHolder<V> holder, BiConsumer<V, CompoundTag> valueSaveFunction) {
        if (holder.hasKey()) {
            return new StringTag(holder.key());
        }
        return this.holderToTag(holder.holder(), valueSaveFunction);
    }

    protected <V> void saveEitherHolderData(StructuredDataKey<EitherHolder<V>> key, StructuredDataContainer data, CompoundTag backupTag, BiConsumer<V, CompoundTag> valueSaveFunction) {
        EitherHolder holder = (EitherHolder)data.get(key);
        if (holder != null) {
            backupTag.put(key.identifier(), this.eitherHolderToTag(holder, valueSaveFunction));
        }
    }

    protected <V> void saveHolderData(StructuredDataKey<Holder<V>> key, StructuredDataContainer data, CompoundTag backupTag, BiConsumer<V, CompoundTag> valueSaveFunction) {
        Holder holder = (Holder)data.get(key);
        if (holder != null) {
            backupTag.put(key.identifier(), this.holderToTag(holder, valueSaveFunction));
        }
    }

    protected <V> Holder<V> restoreHolder(CompoundTag tag, String key, Function<CompoundTag, V> valueRestoreFunction) {
        Tag savedTag = tag.get(key);
        if (savedTag == null) {
            return Holder.of((int)0);
        }
        if (savedTag instanceof IntTag) {
            IntTag idTag = (IntTag)savedTag;
            return Holder.of((int)idTag.asInt());
        }
        if (savedTag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)savedTag;
            return Holder.of(valueRestoreFunction.apply(compoundTag));
        }
        return Holder.of((int)0);
    }

    protected <V> EitherHolder<V> restoreEitherHolder(CompoundTag tag, String key, Function<CompoundTag, V> valueRestoreFunction) {
        Tag savedTag = tag.get(key);
        if (savedTag == null) {
            return EitherHolder.of((Holder)Holder.of((int)0));
        }
        if (savedTag instanceof StringTag) {
            StringTag keyTag = (StringTag)savedTag;
            return EitherHolder.of((String)keyTag.getValue());
        }
        return EitherHolder.of(this.restoreHolder(tag, key, valueRestoreFunction));
    }

    protected <V> void restoreHolderData(StructuredDataKey<Holder<V>> key, StructuredDataContainer data, CompoundTag backupTag, Function<CompoundTag, V> valueRestoreFunction) {
        if (backupTag.contains(key.identifier())) {
            data.set(key, this.restoreHolder(backupTag, key.identifier(), valueRestoreFunction));
        }
    }

    protected void saveStringData(StructuredDataKey<String> key, StructuredDataContainer data, CompoundTag backupTag) {
        String value = (String)data.get(key);
        if (value != null) {
            backupTag.putString(key.identifier(), value);
        }
    }

    protected void restoreStringData(StructuredDataKey<String> key, StructuredDataContainer data, CompoundTag backupTag) {
        String value = backupTag.getString(key.identifier());
        if (value != null) {
            data.set(key, (Object)value);
        }
    }

    protected void saveIntData(StructuredDataKey<Integer> key, StructuredDataContainer data, CompoundTag backupTag) {
        Integer variant = (Integer)data.get(key);
        if (variant != null) {
            backupTag.putInt(key.identifier(), variant.intValue());
        }
    }

    protected void restoreIntData(StructuredDataKey<Integer> key, StructuredDataContainer data, CompoundTag backupTag) {
        IntTag variant = backupTag.getIntTag(key.identifier());
        if (variant != null) {
            data.set(key, (Object)variant.asInt());
        }
    }

    protected void saveFloatData(StructuredDataKey<Float> key, StructuredDataContainer data, CompoundTag backupTag) {
        Float variant = (Float)data.get(key);
        if (variant != null) {
            backupTag.putFloat(key.identifier(), variant.floatValue());
        }
    }

    protected void restoreFloatData(StructuredDataKey<Float> key, StructuredDataContainer data, CompoundTag backupTag) {
        FloatTag variant = backupTag.getFloatTag(key.identifier());
        if (variant != null) {
            data.set(key, (Object)Float.valueOf(variant.asFloat()));
        }
    }

    public String nbtTagName() {
        return "VB|" + ((Object)((Object)((BackwardsProtocol)this.protocol))).getClass().getSimpleName();
    }
}

