/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.v1_21_6to1_21_5;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viabackwards.ViaBackwards;
import com.viaversion.viabackwards.api.BackwardsProtocol;
import com.viaversion.viabackwards.api.data.BackwardsMappingData;
import com.viaversion.viabackwards.api.rewriters.SoundRewriter;
import com.viaversion.viabackwards.api.rewriters.text.NBTComponentRewriter;
import com.viaversion.viabackwards.protocol.v1_21_6to1_21_5.data.Dialog;
import com.viaversion.viabackwards.protocol.v1_21_6to1_21_5.provider.ChestDialogViewProvider;
import com.viaversion.viabackwards.protocol.v1_21_6to1_21_5.provider.DialogViewProvider;
import com.viaversion.viabackwards.protocol.v1_21_6to1_21_5.rewriter.BlockItemPacketRewriter1_21_6;
import com.viaversion.viabackwards.protocol.v1_21_6to1_21_5.rewriter.ComponentRewriter1_21_6;
import com.viaversion.viabackwards.protocol.v1_21_6to1_21_5.rewriter.EntityPacketRewriter1_21_6;
import com.viaversion.viabackwards.protocol.v1_21_6to1_21_5.rewriter.RegistryDataRewriter1_21_6;
import com.viaversion.viabackwards.protocol.v1_21_6to1_21_5.storage.ChestDialogStorage;
import com.viaversion.viabackwards.protocol.v1_21_6to1_21_5.storage.ClickEvents;
import com.viaversion.viabackwards.protocol.v1_21_6to1_21_5.storage.RegistryAndTags;
import com.viaversion.viabackwards.protocol.v1_21_6to1_21_5.storage.ServerLinks;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.data.entity.EntityTracker;
import com.viaversion.viaversion.api.data.item.ItemHasher;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.minecraft.entities.EntityTypes1_21_6;
import com.viaversion.viaversion.api.platform.providers.Provider;
import com.viaversion.viaversion.api.platform.providers.ViaProviders;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.provider.PacketTypesProvider;
import com.viaversion.viaversion.api.protocol.packet.provider.SimplePacketTypesProvider;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.version.VersionedTypes;
import com.viaversion.viaversion.api.type.types.version.VersionedTypesHolder;
import com.viaversion.viaversion.data.entity.EntityTrackerBase;
import com.viaversion.viaversion.data.item.ItemHasherBase;
import com.viaversion.viaversion.protocols.v1_19_3to1_19_4.rewriter.CommandRewriter1_19_4;
import com.viaversion.viaversion.protocols.v1_20_3to1_20_5.packet.ServerboundConfigurationPackets1_20_5;
import com.viaversion.viaversion.protocols.v1_20_5to1_21.packet.ClientboundConfigurationPackets1_21;
import com.viaversion.viaversion.protocols.v1_21_4to1_21_5.packet.ClientboundPacket1_21_5;
import com.viaversion.viaversion.protocols.v1_21_4to1_21_5.packet.ClientboundPackets1_21_5;
import com.viaversion.viaversion.protocols.v1_21_4to1_21_5.packet.ServerboundPacket1_21_5;
import com.viaversion.viaversion.protocols.v1_21_4to1_21_5.packet.ServerboundPackets1_21_5;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.Protocol1_21_5To1_21_6;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ClientboundConfigurationPackets1_21_6;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ClientboundPacket1_21_6;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ClientboundPackets1_21_6;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ServerboundConfigurationPackets1_21_6;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ServerboundPacket1_21_6;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ServerboundPackets1_21_6;
import com.viaversion.viaversion.rewriter.AttributeRewriter;
import com.viaversion.viaversion.rewriter.ParticleRewriter;
import com.viaversion.viaversion.rewriter.RegistryDataRewriter;
import com.viaversion.viaversion.rewriter.StatisticsRewriter;
import com.viaversion.viaversion.rewriter.TagRewriter;
import com.viaversion.viaversion.util.Key;
import com.viaversion.viaversion.util.ProtocolUtil;

public final class Protocol1_21_6To1_21_5
extends BackwardsProtocol<ClientboundPacket1_21_6, ClientboundPacket1_21_5, ServerboundPacket1_21_6, ServerboundPacket1_21_5> {
    public static final BackwardsMappingData MAPPINGS = new BackwardsMappingData("1.21.6", "1.21.5", Protocol1_21_5To1_21_6.class);
    private final EntityPacketRewriter1_21_6 entityRewriter = new EntityPacketRewriter1_21_6(this);
    private final BlockItemPacketRewriter1_21_6 itemRewriter = new BlockItemPacketRewriter1_21_6(this);
    private final ParticleRewriter<ClientboundPacket1_21_6> particleRewriter = new ParticleRewriter((Protocol)this);
    private final NBTComponentRewriter<ClientboundPacket1_21_6> translatableRewriter = new ComponentRewriter1_21_6(this);
    private final TagRewriter<ClientboundPacket1_21_6> tagRewriter = new TagRewriter((Protocol)this);
    private final RegistryDataRewriter registryDataRewriter = new RegistryDataRewriter1_21_6(this);

    public Protocol1_21_6To1_21_5() {
        super(ClientboundPacket1_21_6.class, ClientboundPacket1_21_5.class, ServerboundPacket1_21_6.class, ServerboundPacket1_21_5.class);
    }

    @Override
    protected void registerPackets() {
        super.registerPackets();
        this.registerClientbound((ClientboundPacketType)ClientboundConfigurationPackets1_21_6.REGISTRY_DATA, arg_0 -> ((RegistryDataRewriter)this.registryDataRewriter).handle(arg_0));
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_21_6.UPDATE_TAGS, this::updateTags);
        this.registerClientbound((ClientboundPacketType)ClientboundConfigurationPackets1_21_6.UPDATE_TAGS, this::updateTags);
        SoundRewriter<ClientboundPacket1_21_6> soundRewriter = new SoundRewriter<ClientboundPacket1_21_6>(this);
        soundRewriter.registerSound1_19_3((ClientboundPacket1_21_6)ClientboundPackets1_21_6.SOUND);
        this.appendClientbound((ClientboundPacketType)ClientboundPackets1_21_6.SOUND, wrapper -> {
            wrapper.passthrough((Type)Types.VAR_INT);
            this.fixSoundSource(wrapper);
        });
        soundRewriter.registerSound1_19_3((ClientboundPacket1_21_6)ClientboundPackets1_21_6.SOUND_ENTITY);
        this.appendClientbound((ClientboundPacketType)ClientboundPackets1_21_6.SOUND_ENTITY, wrapper -> {
            wrapper.passthrough((Type)Types.VAR_INT);
            this.fixSoundSource(wrapper);
        });
        soundRewriter.registerStopSound((ClientboundPacket1_21_6)ClientboundPackets1_21_6.STOP_SOUND);
        this.appendClientbound((ClientboundPacketType)ClientboundPackets1_21_6.STOP_SOUND, wrapper -> {
            byte flags = (Byte)wrapper.get((Type)Types.BYTE, 0);
            if ((flags & 1) != 0) {
                this.fixSoundSource(wrapper);
            }
        });
        new StatisticsRewriter((Protocol)this).register((ClientboundPacketType)ClientboundPackets1_21_6.AWARD_STATS);
        new AttributeRewriter((Protocol)this).register1_21((ClientboundPacketType)ClientboundPackets1_21_6.UPDATE_ATTRIBUTES);
        new CommandRewriter1_19_4<ClientboundPacket1_21_6>((Protocol)this){

            public void handleArgument(PacketWrapper wrapper, String argumentType) {
                if (argumentType.equals("minecraft:hex_color") || argumentType.equals("minecraft:dialog")) {
                    wrapper.write((Type)Types.VAR_INT, (Object)0);
                } else {
                    super.handleArgument(wrapper, argumentType);
                }
            }
        }.registerDeclareCommands1_19((ClientboundPacketType)ClientboundPackets1_21_6.COMMANDS);
        this.translatableRewriter.registerOpenScreen1_14((ClientboundPacketType)ClientboundPackets1_21_6.OPEN_SCREEN);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_21_6.SET_ACTION_BAR_TEXT);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_21_6.SET_TITLE_TEXT);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_21_6.SET_SUBTITLE_TEXT);
        this.translatableRewriter.registerBossEvent((ClientboundPacketType)ClientboundPackets1_21_6.BOSS_EVENT);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_21_6.DISCONNECT);
        this.translatableRewriter.registerTabList((ClientboundPacketType)ClientboundPackets1_21_6.TAB_LIST);
        this.translatableRewriter.registerPlayerCombatKill1_20((ClientboundPacketType)ClientboundPackets1_21_6.PLAYER_COMBAT_KILL);
        this.translatableRewriter.registerPlayerInfoUpdate1_21_4((ClientboundPacketType)ClientboundPackets1_21_6.PLAYER_INFO_UPDATE);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_21_6.SYSTEM_CHAT);
        this.translatableRewriter.registerDisguisedChat((ClientboundPacketType)ClientboundPackets1_21_6.DISGUISED_CHAT);
        this.translatableRewriter.registerPlayerChat1_21_5((ClientboundPacketType)ClientboundPackets1_21_6.PLAYER_CHAT);
        this.translatableRewriter.registerPing();
        this.particleRewriter.registerLevelParticles1_21_4((ClientboundPacketType)ClientboundPackets1_21_6.LEVEL_PARTICLES);
        this.particleRewriter.registerExplode1_21_2((ClientboundPacketType)ClientboundPackets1_21_6.EXPLODE);
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_21_6.CHANGE_DIFFICULTY, wrapper -> {
            int difficulty = (Integer)wrapper.read((Type)Types.VAR_INT);
            wrapper.write((Type)Types.UNSIGNED_BYTE, (Object)((short)difficulty));
        });
        this.registerServerbound((ServerboundPacketType)ServerboundPackets1_21_5.CHANGE_DIFFICULTY, wrapper -> {
            short difficulty = (Short)wrapper.read((Type)Types.UNSIGNED_BYTE);
            wrapper.write((Type)Types.VAR_INT, (Object)difficulty);
        });
        this.registerServerbound((ServerboundPacketType)ServerboundPackets1_21_5.CHAT_COMMAND, this::handleClickEvents);
        this.registerServerbound((ServerboundPacketType)ServerboundPackets1_21_5.CHAT_COMMAND_SIGNED, this::handleClickEvents);
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_21_6.SHOW_DIALOG, null, wrapper -> {
            wrapper.cancel();
            if (!ViaBackwards.getConfig().dialogsViaChests()) {
                return;
            }
            RegistryAndTags registryAndTags = (RegistryAndTags)wrapper.user().get(RegistryAndTags.class);
            ServerLinks serverLinks = (ServerLinks)wrapper.user().get(ServerLinks.class);
            int id = (Integer)wrapper.read((Type)Types.VAR_INT) - 1;
            CompoundTag tag = id == -1 ? (CompoundTag)wrapper.read(Types.TAG) : registryAndTags.fromRegistry(id);
            DialogViewProvider provider = (DialogViewProvider)Via.getManager().getProviders().get(DialogViewProvider.class);
            provider.openDialog(wrapper.user(), new Dialog(registryAndTags, serverLinks, tag));
        });
        this.registerClientbound((ClientboundPacketType)ClientboundConfigurationPackets1_21_6.SHOW_DIALOG, null, wrapper -> {
            wrapper.cancel();
            if (!ViaBackwards.getConfig().dialogsViaChests()) {
                return;
            }
            RegistryAndTags registryAndTags = (RegistryAndTags)wrapper.user().get(RegistryAndTags.class);
            ServerLinks serverLinks = (ServerLinks)wrapper.user().get(ServerLinks.class);
            CompoundTag tag = (CompoundTag)wrapper.read(Types.TAG);
            DialogViewProvider provider = (DialogViewProvider)Via.getManager().getProviders().get(DialogViewProvider.class);
            provider.openDialog(wrapper.user(), new Dialog(registryAndTags, serverLinks, tag));
        });
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_21_6.CLEAR_DIALOG, null, this::clearDialog);
        this.registerClientbound((ClientboundPacketType)ClientboundConfigurationPackets1_21_6.CLEAR_DIALOG, null, this::clearDialog);
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_21_6.SERVER_LINKS, this::storeServerLinks);
        this.registerClientbound((ClientboundPacketType)ClientboundConfigurationPackets1_21_6.SERVER_LINKS, this::storeServerLinks);
        this.registerServerbound((ServerboundPacketType)ServerboundPackets1_21_5.CONTAINER_CLOSE, wrapper -> {
            ChestDialogStorage storage = (ChestDialogStorage)wrapper.user().get(ChestDialogStorage.class);
            if (storage == null) {
                return;
            }
            ChestDialogViewProvider provider = (ChestDialogViewProvider)Via.getManager().getProviders().get(DialogViewProvider.class);
            if (storage.phase() == ChestDialogStorage.Phase.ANVIL_VIEW) {
                wrapper.cancel();
                provider.openChestView(wrapper.user(), storage, ChestDialogStorage.Phase.DIALOG_VIEW);
                return;
            }
            if (storage.phase() == ChestDialogStorage.Phase.WAITING_FOR_RESPONSE) {
                wrapper.cancel();
                if (storage.closeButtonEnabled()) {
                    provider.openChestView(wrapper.user(), storage, ChestDialogStorage.Phase.DIALOG_VIEW);
                } else {
                    provider.openChestView(wrapper.user(), storage, ChestDialogStorage.Phase.WAITING_FOR_RESPONSE);
                }
                return;
            }
            boolean allowClosing = storage.allowClosing();
            if (!allowClosing) {
                wrapper.cancel();
                if (storage.dialog().canCloseWithEscape()) {
                    provider.clickButton(wrapper.user(), Dialog.AfterAction.CLOSE, storage.dialog().actionButton());
                } else {
                    provider.openChestView(wrapper.user(), storage, ChestDialogStorage.Phase.DIALOG_VIEW);
                }
            }
            storage.setAllowClosing(false);
        });
        this.registerServerbound((ServerboundPacketType)ServerboundPackets1_21_5.RENAME_ITEM, wrapper -> {
            ChestDialogStorage storage = (ChestDialogStorage)wrapper.user().get(ChestDialogStorage.class);
            if (storage == null || storage.phase() != ChestDialogStorage.Phase.ANVIL_VIEW) {
                return;
            }
            wrapper.cancel();
            String name = (String)wrapper.read(Types.STRING);
            ChestDialogViewProvider provider = (ChestDialogViewProvider)Via.getManager().getProviders().get(DialogViewProvider.class);
            provider.updateAnvilText(wrapper.user(), name);
        });
        this.appendServerbound((ServerboundPacketType)ServerboundPackets1_21_5.CONTAINER_CLICK, wrapper -> {
            ChestDialogViewProvider provider = (ChestDialogViewProvider)Via.getManager().getProviders().get(DialogViewProvider.class);
            if (provider == null) {
                return;
            }
            int containerId = (Integer)wrapper.get((Type)Types.VAR_INT, 0);
            short slot = (Short)wrapper.get((Type)Types.SHORT, 0);
            byte button = (Byte)wrapper.get((Type)Types.BYTE, 0);
            int mode = (Integer)wrapper.get((Type)Types.VAR_INT, 2);
            if (provider.clickDialog(wrapper.user(), containerId, slot, button, mode)) {
                wrapper.cancel();
            }
        });
        this.cancelClientbound((ClientboundPacketType)ClientboundPackets1_21_6.TRACKED_WAYPOINT);
    }

    private void fixSoundSource(PacketWrapper wrapper) {
        int source = (Integer)wrapper.get((Type)Types.VAR_INT, 0);
        if (source == 10) {
            wrapper.set((Type)Types.VAR_INT, 0, (Object)0);
        }
    }

    private void updateTags(PacketWrapper wrapper) {
        this.tagRewriter.handleGeneric(wrapper);
        wrapper.resetReader();
        RegistryAndTags registryAndTags = (RegistryAndTags)wrapper.user().get(RegistryAndTags.class);
        int length = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
        for (int i = 0; i < length; ++i) {
            int j;
            int tagsSize;
            String registryKey = (String)wrapper.read(Types.STRING);
            boolean dialog = "dialog".equals(Key.stripMinecraftNamespace((String)registryKey));
            if (dialog) {
                tagsSize = (Integer)wrapper.read((Type)Types.VAR_INT);
                for (j = 0; j < tagsSize; ++j) {
                    String key = (String)wrapper.read(Types.STRING);
                    int[] ids = (int[])wrapper.read(Types.VAR_INT_ARRAY_PRIMITIVE);
                    registryAndTags.storeTags(key, ids);
                }
                continue;
            }
            wrapper.write(Types.STRING, (Object)registryKey);
            tagsSize = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
            for (j = 0; j < tagsSize; ++j) {
                wrapper.passthrough(Types.STRING);
                wrapper.passthrough(Types.VAR_INT_ARRAY_PRIMITIVE);
            }
        }
        if (registryAndTags.tagsSent()) {
            wrapper.set((Type)Types.VAR_INT, 0, (Object)(length - 1));
        }
    }

    private void clearDialog(PacketWrapper wrapper) {
        wrapper.cancel();
        if (!ViaBackwards.getConfig().dialogsViaChests()) {
            return;
        }
        DialogViewProvider provider = (DialogViewProvider)Via.getManager().getProviders().get(DialogViewProvider.class);
        provider.closeDialog(wrapper.user());
    }

    private void storeServerLinks(PacketWrapper wrapper) {
        ServerLinks serverLinks = new ServerLinks();
        int length = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
        for (int i = 0; i < length; ++i) {
            String url;
            if (((Boolean)wrapper.passthrough((Type)Types.BOOLEAN)).booleanValue()) {
                int id = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
                url = (String)wrapper.passthrough(Types.STRING);
                serverLinks.storeLink(id, url);
                continue;
            }
            Tag tag = (Tag)wrapper.passthrough(Types.TAG);
            url = (String)wrapper.passthrough(Types.STRING);
            serverLinks.storeLink(tag, url);
        }
        wrapper.user().put((StorableObject)serverLinks);
    }

    private void handleClickEvents(PacketWrapper wrapper) {
        String command = (String)wrapper.passthrough(Types.STRING);
        ClickEvents clickEvents = (ClickEvents)wrapper.user().get(ClickEvents.class);
        if (clickEvents.handleChatCommand(wrapper.user(), command)) {
            wrapper.cancel();
        }
    }

    public void init(UserConnection user) {
        this.addEntityTracker(user, (EntityTracker)new EntityTrackerBase(user, (EntityType)EntityTypes1_21_6.PLAYER));
        this.addItemHasher(user, (ItemHasher)new ItemHasherBase((Protocol)this, user));
        user.put((StorableObject)new RegistryAndTags());
        user.put((StorableObject)new ClickEvents());
    }

    public void register(ViaProviders providers) {
        providers.register(DialogViewProvider.class, (Provider)new ChestDialogViewProvider(this));
    }

    @Override
    public BackwardsMappingData getMappingData() {
        return MAPPINGS;
    }

    public EntityPacketRewriter1_21_6 getEntityRewriter() {
        return this.entityRewriter;
    }

    public BlockItemPacketRewriter1_21_6 getItemRewriter() {
        return this.itemRewriter;
    }

    public RegistryDataRewriter getRegistryDataRewriter() {
        return this.registryDataRewriter;
    }

    public ParticleRewriter<ClientboundPacket1_21_6> getParticleRewriter() {
        return this.particleRewriter;
    }

    @Override
    public NBTComponentRewriter<ClientboundPacket1_21_6> getComponentRewriter() {
        return this.translatableRewriter;
    }

    public TagRewriter<ClientboundPacket1_21_6> getTagRewriter() {
        return this.tagRewriter;
    }

    public VersionedTypesHolder types() {
        return VersionedTypes.V1_21_6;
    }

    public VersionedTypesHolder mappedTypes() {
        return VersionedTypes.V1_21_5;
    }

    protected PacketTypesProvider<ClientboundPacket1_21_6, ClientboundPacket1_21_5, ServerboundPacket1_21_6, ServerboundPacket1_21_5> createPacketTypesProvider() {
        return new SimplePacketTypesProvider(ProtocolUtil.packetTypeMap((Class)this.unmappedClientboundPacketType, (Class[])new Class[]{ClientboundPackets1_21_6.class, ClientboundConfigurationPackets1_21_6.class}), ProtocolUtil.packetTypeMap((Class)this.mappedClientboundPacketType, (Class[])new Class[]{ClientboundPackets1_21_5.class, ClientboundConfigurationPackets1_21.class}), ProtocolUtil.packetTypeMap((Class)this.mappedServerboundPacketType, (Class[])new Class[]{ServerboundPackets1_21_6.class, ServerboundConfigurationPackets1_21_6.class}), ProtocolUtil.packetTypeMap((Class)this.unmappedServerboundPacketType, (Class[])new Class[]{ServerboundPackets1_21_5.class, ServerboundConfigurationPackets1_20_5.class}));
    }
}

