/*
 * Decompiled with CFR 0.152.
 */
package dev.unowly.timber.events;

import dev.unowly.timber.Timber;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class TimberListener
implements Listener {
    private final Timber timber;

    public TimberListener(Timber timber) {
        this.timber = timber;
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (!this.timber.getTimberEnabled().contains(player.getUniqueId())) {
            return;
        }
        Block b = event.getBlock();
        if (b.getType() != Material.OAK_LOG || b.getType().toString().endsWith("_LOG")) {
            this.breakTree(b);
        }
    }

    private void breakTree(Block b) {
        HashSet<Block> toBreak = new HashSet<Block>();
        toBreak.add(b);
        this.findConnectedLogs(b, toBreak);
        for (Block log : toBreak) {
            log.breakNaturally(new ItemStack(Material.DIAMOND_AXE));
        }
    }

    private void findConnectedLogs(Block block, Set<Block> toBreak) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    Block nearby = block.getRelative(x, y, z);
                    if (toBreak.contains(nearby) || nearby.getType() != Material.OAK_LOG && !nearby.getType().toString().endsWith("_LOG")) continue;
                    toBreak.add(nearby);
                    this.findConnectedLogs(nearby, toBreak);
                }
            }
        }
    }
}

