/*
 * Decompiled with CFR 0.152.
 */
package com.itemcolor.commands;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class NameCommand
implements CommandExecutor {
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.legacyAmpersand();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("itemcolor.name")) {
            player.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            player.sendMessage("\u00a7cUsage: /name <name>");
            player.sendMessage("\u00a77You can use color codes (&), MiniMessage format (<red>, <bold>, etc.), and unicode characters!");
            player.sendMessage("\u00a77Examples:");
            player.sendMessage("\u00a77  /name &c&lRed Bold Text");
            player.sendMessage("\u00a77  /name <red><bold>Modern Red Bold");
            player.sendMessage("\u00a77  /name \u2605 Special Symbol \u2605");
            player.sendMessage("\u00a77  /name \u2655 Unicode Crown \u2655");
            return true;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() == Material.AIR) {
            player.sendMessage("\u00a7cYou must be holding an item to rename it!");
            return true;
        }
        StringBuilder nameBuilder = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            nameBuilder.append(args[i]);
            if (i >= args.length - 1) continue;
            nameBuilder.append(" ");
        }
        String rawName = nameBuilder.toString();
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            player.sendMessage("\u00a7cThis item cannot be renamed!");
            return true;
        }
        try {
            Component displayName = this.processName(rawName);
            meta.displayName(displayName);
            item.setItemMeta(meta);
            player.sendMessage("\u00a7aItem renamed successfully!");
            String preview = this.legacySerializer.serialize(displayName);
            player.sendMessage("\u00a77Preview: " + preview);
        }
        catch (Exception e) {
            player.sendMessage("\u00a7cError processing the name. Please check your formatting!");
            player.sendMessage("\u00a77Make sure you're using valid color codes or MiniMessage format.");
        }
        return true;
    }

    private Component processName(String rawName) {
        if (rawName.contains("<") && rawName.contains(">")) {
            try {
                return this.miniMessage.deserialize((Object)rawName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (rawName.contains("&")) {
            return this.legacySerializer.deserialize(rawName);
        }
        return Component.text((String)rawName);
    }
}

