/*
 * Decompiled with CFR 0.152.
 */
package dev.kiddo.nearvanillashopdirectorymod.commands;

import dev.kiddo.nearvanillashopdirectorymod.NearVanillaShopDirectoryMod;
import dev.kiddo.nearvanillashopdirectorymod.commands.Shop;
import dev.kiddo.nearvanillashopdirectorymod.shop.ShopItem;
import dev.kiddo.nearvanillashopdirectorymod.shop.ShopManager;
import java.util.List;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;

public class CommandManager {
    public static void registerCommands() {
        NearVanillaShopDirectoryMod.LOGGER.info("Registering commands...");
        ClientCommandRegistrationCallback.EVENT.register(Shop::register);
        NearVanillaShopDirectoryMod.LOGGER.info("Commands registered successfully");
    }

    public static void handleShopSearch(String itemName) {
        try {
            List<ShopItem> shops = ShopManager.findShopsWithItem(itemName);
            if (shops.isEmpty()) {
                NearVanillaShopDirectoryMod.LOGGER.info("No shops found selling: {}", (Object)itemName);
            } else {
                NearVanillaShopDirectoryMod.LOGGER.info("Found {} shops selling {}", (Object)shops.size(), (Object)itemName);
                for (ShopItem shop : shops) {
                    NearVanillaShopDirectoryMod.LOGGER.info("Shop: {} | Owner: {} | Coords: {} | Spawn: {}", new Object[]{shop.getShopName(), shop.getOwnerIGN(), shop.getCoords(), shop.getSpawn()});
                }
            }
        }
        catch (Exception e) {
            NearVanillaShopDirectoryMod.LOGGER.error("Error searching for shops with item: {}", (Object)itemName, (Object)e);
        }
    }

    public static void handleShopReload() {
        try {
            ShopManager.updateAndLoadShops();
            NearVanillaShopDirectoryMod.LOGGER.info("Shop data reloaded successfully");
        }
        catch (Exception e) {
            NearVanillaShopDirectoryMod.LOGGER.error("Failed to reload shop data", (Throwable)e);
        }
    }
}

