/*
 * Decompiled with CFR 0.152.
 */
package dev.kiddo.nearvanillashopdirectorymod.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.kiddo.nearvanillashopdirectorymod.shop.ShopItem;
import dev.kiddo.nearvanillashopdirectorymod.shop.ShopManager;
import java.util.List;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.modcommon.MinecraftClientAudiences;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minecraft.class_2287;
import net.minecraft.class_2290;
import net.minecraft.class_7157;

public class Shop {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 commandRegistryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"shop").then(ClientCommandManager.argument((String)"item", (ArgumentType)class_2287.method_9776((class_7157)commandRegistryAccess)).executes(context -> {
            class_2290 itemStack = class_2287.method_9777((CommandContext)context, (String)"item");
            String itemStackName = itemStack.method_9785().toString().replace("minecraft:", "");
            String itemStackMCName = itemStack.method_9785().method_63680().getString();
            FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
            List<ShopItem> shops = ShopManager.findShopsWithItem(itemStackName.toLowerCase());
            if (shops.isEmpty()) {
                Shop.sendNotFoundMessage(source, itemStackMCName);
                return 0;
            }
            Shop.sendFoundMessage(source, shops.size(), itemStackMCName, itemStackName);
            for (ShopItem shop : shops) {
                Shop.sendShopInfo(source, shop);
            }
            return 1;
        }))).then(ClientCommandManager.literal((String)"art").executes(context -> {
            List<ShopItem> shops = ShopManager.findShopsWithItem("map_art");
            FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
            String itemStackMCName = "Map Art";
            String itemStackName = "map_art";
            if (shops.isEmpty()) {
                Shop.sendNotFoundMessage(source, itemStackMCName);
                return 0;
            }
            Shop.sendFoundMessage(source, shops.size(), itemStackMCName, itemStackName);
            for (ShopItem shop : shops) {
                Shop.sendShopInfo(source, shop);
            }
            return 1;
        })));
    }

    private static void sendNotFoundMessage(FabricClientCommandSource source, String itemStackMCName) {
        Component message = Component.text((String)"Couldn't find any shops selling ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)itemStackMCName, (TextColor)NamedTextColor.YELLOW));
        Audience client = MinecraftClientAudiences.of().audience();
        client.sendMessage(message);
    }

    private static void sendFoundMessage(FabricClientCommandSource source, int count, String itemStackMCName, String itemStackName) {
        String countString = count == 1 ? "shop" : "shops";
        Component foundMsg = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Found ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)(Integer.toString(count) + " "), (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)countString, (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)" selling ", (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)itemStackMCName, (TextColor)NamedTextColor.YELLOW));
        if (ShopItem.isArmorTrim(itemStackName)) {
            foundMsg = foundMsg.append(Component.text((String)("\nNote: The " + countString + " may not sell this exact trim."), (TextColor)NamedTextColor.RED).decorate(TextDecoration.BOLD));
        }
        if (ShopItem.isPotterySherd(itemStackName)) {
            foundMsg = foundMsg.append(Component.text((String)("\nNote: The " + countString + " may not sell this exact sherd."), (TextColor)NamedTextColor.RED).decorate(TextDecoration.BOLD));
        }
        Audience client = MinecraftClientAudiences.of().audience();
        client.sendMessage(foundMsg);
    }

    private static void sendShopInfo(FabricClientCommandSource source, ShopItem shop) {
        String[] owners = shop.getOwnerIGN().split(",");
        boolean multipleOwners = owners.length > 1;
        TextComponent hoverComponent = Component.text((String)(multipleOwners ? "Owners:\n" : "Owner:\n"), (TextColor)NamedTextColor.GOLD);
        for (int i = 0; i < owners.length; ++i) {
            hoverComponent = hoverComponent.append((Component)Component.text((String)owners[i].trim(), (TextColor)NamedTextColor.YELLOW));
            if (i >= owners.length - 1) continue;
            hoverComponent = hoverComponent.append((Component)Component.text((String)"\n"));
        }
        Component shopInfo = ((TextComponent)((TextComponent)Component.text((String)shop.getShopName(), (TextColor)NamedTextColor.AQUA).hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverComponent))).append((Component)Component.text((String)", ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)shop.getCoords(), (TextColor)NamedTextColor.BLUE));
        Audience client = MinecraftClientAudiences.of().audience();
        client.sendMessage(shopInfo);
    }
}

