/*
 * Decompiled with CFR 0.152.
 */
package dev.kiddo.nearvanillashopdirectorymod.config;

import dev.kiddo.nearvanillashopdirectorymod.NearVanillaShopDirectoryMod;
import dev.kiddo.nearvanillashopdirectorymod.config.Config;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;

public class ConfigurationManager {
    private static final Map<String, String> DEFAULT_CONFIG = Map.of("config_directory", "InGameShopDir", "shops_url", "https://kiddo.dev/files/shops.csv", "version_url", "https://kiddo.dev/files/shops_version.txt");
    private static Config config;
    private static Path configPath;

    public static void init(Path configDir) throws IOException {
        configPath = configDir.resolve("config.properties");
        config = ConfigurationManager.loadConfiguration();
    }

    public static Config getConfig() {
        if (config == null) {
            throw new IllegalStateException("Configuration not initialized");
        }
        return config;
    }

    private static Config loadConfiguration() throws IOException {
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                config = Config.fromProperties(configPath);
                NearVanillaShopDirectoryMod.LOGGER.info("Loaded configuration from file");
                return config;
            }
            catch (IOException e) {
                NearVanillaShopDirectoryMod.LOGGER.warn("Failed to load configuration file, using defaults", (Throwable)e);
            }
        }
        NearVanillaShopDirectoryMod.LOGGER.info("Using default configuration");
        config = Config.fromDefaults(DEFAULT_CONFIG);
        ConfigurationManager.saveDefaultConfiguration();
        return config;
    }

    private static void saveDefaultConfiguration() {
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            Properties properties = new Properties();
            for (Map.Entry<String, String> entry : DEFAULT_CONFIG.entrySet()) {
                properties.setProperty(entry.getKey(), entry.getValue());
            }
            try (OutputStream out = Files.newOutputStream(configPath, new OpenOption[0]);){
                properties.store(out, "InGameShopDir Configuration");
            }
            NearVanillaShopDirectoryMod.LOGGER.info("Saved default configuration to {}", (Object)configPath);
        }
        catch (IOException e) {
            NearVanillaShopDirectoryMod.LOGGER.error("Failed to save default configuration", (Throwable)e);
        }
    }
}

