/*
 * Decompiled with CFR 0.152.
 */
package dev.kiddo.nearvanillashopdirectorymod.shop;

import dev.kiddo.nearvanillashopdirectorymod.csv.CsvRecord;
import dev.kiddo.nearvanillashopdirectorymod.shop.ShopItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ShopLoader {
    private final Map<String, List<ShopItem>> shopItems = new HashMap<String, List<ShopItem>>();

    public List<ShopItem> findAllShopsWithItem(String shopItem) {
        String normalizedInput = this.normalizeItemName(shopItem);
        return this.shopItems.values().stream().flatMap(Collection::stream).filter(shop -> this.containsItem((ShopItem)shop, normalizedInput)).collect(Collectors.toList());
    }

    private boolean containsItem(ShopItem shop, String itemName) {
        return Arrays.stream(shop.getInventory().split(",")).map(this::normalizeItemName).anyMatch(item -> item.equals(itemName));
    }

    private String normalizeItemName(String name) {
        return name.trim().toLowerCase().replace(" ", "");
    }

    public ShopItem parseShopItem(CsvRecord record) throws IllegalArgumentException {
        if (record.fieldCount() < 5) {
            throw new IllegalArgumentException("Invalid number of fields");
        }
        ShopItem item = new ShopItem();
        item.setShopName(record.getField(0));
        item.setInventory(record.getField(1).replaceAll("\\s+", " ").toLowerCase());
        item.setOwnerIGN(record.getField(2));
        item.setCoords(record.getField(3));
        item.setSpawn(record.getField(4));
        return item;
    }

    public Map<String, List<ShopItem>> getShopItems() {
        return new HashMap<String, List<ShopItem>>(this.shopItems);
    }

    public void addShopItem(String key, ShopItem item) {
        this.shopItems.computeIfAbsent(key, k -> new ArrayList()).add(item);
    }
}

