/*
 * Decompiled with CFR 0.152.
 */
package dev.kiddo.nearvanillashopdirectorymod;

import dev.kiddo.nearvanillashopdirectorymod.commands.CommandManager;
import dev.kiddo.nearvanillashopdirectorymod.config.ConfigurationManager;
import dev.kiddo.nearvanillashopdirectorymod.libs.FileHandler;
import dev.kiddo.nearvanillashopdirectorymod.shop.ShopManager;
import java.nio.file.Path;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NearVanillaShopDirectoryMod
implements ClientModInitializer {
    public static final String MOD_ID = "nearvanillashopdirectorymod";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"nearvanillashopdirectorymod");
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir().resolve("InGameShopDir");

    public static Path getConfigDir() {
        return CONFIG_DIR;
    }

    public void onInitializeClient() {
        LOGGER.info("Initializing InGameShopDir client");
        try {
            this.initializeConfiguration();
            this.initializeFileSystem();
            this.initializeShops();
            this.initializeCommands();
            LOGGER.info("InGameShopDir initialized successfully");
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize InGameShopDir", (Throwable)e);
        }
    }

    private void initializeConfiguration() throws Exception {
        LOGGER.debug("Initializing configuration...");
        ConfigurationManager.init(CONFIG_DIR);
    }

    private void initializeFileSystem() throws Exception {
        LOGGER.debug("Setting up file system...");
        FileHandler.ensureDirectoryExists(CONFIG_DIR);
    }

    private void initializeShops() throws Exception {
        LOGGER.debug("Loading shops...");
        ShopManager.updateAndLoadShops();
    }

    private void initializeCommands() throws Exception {
        LOGGER.debug("Registering commands...");
        CommandManager.registerCommands();
    }
}

