/*
 * Decompiled with CFR 0.152.
 */
package dev.kiddo.nearvanillashopdirectorymod.config;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Config {
    private final Map<String, String> properties;

    private Config(Map<String, String> properties) {
        this.properties = new HashMap<String, String>(properties);
    }

    public String getString(String key) {
        return this.properties.get(key);
    }

    public String getString(String key, String defaultValue) {
        return this.properties.getOrDefault(key, defaultValue);
    }

    public static Config fromDefaults(Map<String, String> defaults) {
        return new Config(defaults);
    }

    public static Config fromProperties(Path path) throws IOException {
        Properties props = new Properties();
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            props.load(in);
        }
        HashMap<String, String> configMap = new HashMap<String, String>();
        for (String key : props.stringPropertyNames()) {
            configMap.put(key, props.getProperty(key));
        }
        return new Config(configMap);
    }

    public Map<String, String> getAllProperties() {
        return new HashMap<String, String>(this.properties);
    }
}

