/*
 * Decompiled with CFR 0.152.
 */
package dev.kiddo.nearvanillashopdirectorymod.shop;

import dev.kiddo.nearvanillashopdirectorymod.NearVanillaShopDirectoryMod;
import dev.kiddo.nearvanillashopdirectorymod.config.ConfigurationManager;
import dev.kiddo.nearvanillashopdirectorymod.exceptions.ShopException;
import dev.kiddo.nearvanillashopdirectorymod.libs.FileHandler;
import dev.kiddo.nearvanillashopdirectorymod.shop.ShopItem;
import dev.kiddo.nearvanillashopdirectorymod.shop.ShopLoader;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.Objects;

public class ShopManager {
    private static final String SHOPS_FILE_NAME = "shops.csv";
    private static final String VERSION_FILE_NAME = "shops_version.txt";
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    private static final Base64.Encoder ENCODER = Base64.getUrlEncoder();
    private static final Base64.Decoder DECODER = Base64.getUrlDecoder();
    private static final ShopLoader shopLoader = new ShopLoader();

    public static void updateAndLoadShops() throws ShopException {
        Path configDir = NearVanillaShopDirectoryMod.getConfigDir();
        Path shopsFilePath = configDir.resolve(SHOPS_FILE_NAME);
        Path versionFilePath = configDir.resolve(VERSION_FILE_NAME);
        try {
            if (ShopManager.shouldUpdate(versionFilePath)) {
                NearVanillaShopDirectoryMod.LOGGER.info("New version detected. Updating...");
                ShopManager.downloadAndUpdate(shopsFilePath, versionFilePath);
            }
            if (!FileHandler.safeLoadCSV(shopsFilePath)) {
                throw new ShopException("Failed to load shops.csv after update");
            }
            NearVanillaShopDirectoryMod.LOGGER.info("Successfully updated and loaded shops.csv");
        }
        catch (IOException e) {
            throw new ShopException("Failed to update shops.csv", e);
        }
    }

    private static boolean shouldUpdate(Path versionFilePath) throws IOException {
        String remoteVersion;
        String localVersion = FileHandler.readLocalVersion(versionFilePath);
        return !Objects.equals(localVersion, remoteVersion = ShopManager.getRemoteVersion());
    }

    private static String getRemoteVersion() throws IOException {
        String versionUrl = ConfigurationManager.getConfig().getString("version_url");
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(versionUrl)).timeout(Duration.ofSeconds(30L)).GET().build();
        try {
            HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new IOException("HTTP " + response.statusCode() + " when fetching version");
            }
            return response.body().trim();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Request interrupted", e);
        }
    }

    private static void downloadAndUpdate(Path shopsFilePath, Path versionFilePath) throws ShopException {
        String shopsUrl = ConfigurationManager.getConfig().getString("shops_url");
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(ShopManager.getCacheBustedUrl(shopsUrl))).GET().header("Cache-Control", "no-cache").timeout(Duration.ofSeconds(60L)).build();
        try {
            HttpResponse<Path> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofFile(shopsFilePath));
            if (response.statusCode() != 200) {
                throw new IOException("Failed to download CSV: " + response.statusCode());
            }
            FileHandler.updateVersionFile(versionFilePath, ShopManager.getRemoteVersion());
        }
        catch (IOException | InterruptedException e) {
            throw new ShopException("Failed to download shops.csv", e);
        }
    }

    private static String getCacheBustedUrl(String baseUrl) {
        return baseUrl + "?t=" + System.currentTimeMillis();
    }

    public static String encode(String string) {
        return ENCODER.encodeToString(string.replace(",", "+").replace("_", "/").getBytes(StandardCharsets.UTF_8));
    }

    public static String decodeInventory(String string) {
        try {
            byte[] decodedBytes = DECODER.decode(string);
            return new String(decodedBytes, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            NearVanillaShopDirectoryMod.LOGGER.error("Failed to decode inventory string: " + string, (Throwable)e);
            return "";
        }
    }

    public static void addShopItem(ShopItem item) {
        String encodedShopName = ShopManager.encode(item.getShopName().toLowerCase());
        shopLoader.addShopItem(encodedShopName, item);
    }

    public static List<ShopItem> findShopsWithItem(String itemName) {
        return shopLoader.findAllShopsWithItem(itemName);
    }
}

