/*
 * Decompiled with CFR 0.152.
 */
package dev.kiddo.nearvanillashopdirectorymod.csv;

import dev.kiddo.nearvanillashopdirectorymod.csv.CsvRecord;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSVParser
implements AutoCloseable {
    private static final Pattern CSV_PATTERN = Pattern.compile("\"([^\"]*)\"|([^,]+)");
    private final BufferedReader reader;
    private int lineNumber = 0;

    public CSVParser(Path filePath) throws IOException {
        this.reader = Files.newBufferedReader(filePath);
    }

    public List<CsvRecord> parse() throws IOException {
        String line;
        ArrayList<CsvRecord> records = new ArrayList<CsvRecord>();
        while ((line = this.reader.readLine()) != null) {
            String trimmedLine = line.trim();
            if (trimmedLine.isEmpty()) continue;
            ++this.lineNumber;
            List<String> fields = this.parseFields(trimmedLine);
            records.add(new CsvRecord(this.lineNumber, fields.toArray(new String[0])));
        }
        return records;
    }

    private List<String> parseFields(String line) {
        ArrayList<String> fields = new ArrayList<String>();
        Matcher matcher = CSV_PATTERN.matcher(line);
        while (matcher.find()) {
            String field = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
            fields.add(field != null ? field.trim() : "");
        }
        return fields;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

