/*
 * Decompiled with CFR 0.152.
 */
package dev.kiddo.nearvanillashopdirectorymod.libs;

import dev.kiddo.nearvanillashopdirectorymod.NearVanillaShopDirectoryMod;
import dev.kiddo.nearvanillashopdirectorymod.csv.CSVParser;
import dev.kiddo.nearvanillashopdirectorymod.csv.CsvRecord;
import dev.kiddo.nearvanillashopdirectorymod.shop.ShopItem;
import dev.kiddo.nearvanillashopdirectorymod.shop.ShopLoader;
import dev.kiddo.nearvanillashopdirectorymod.shop.ShopManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class FileHandler {
    public static void ensureDirectoryExists(Path directory) {
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
            NearVanillaShopDirectoryMod.LOGGER.debug("Ensured directory exists: {}", (Object)directory);
        }
        catch (IOException e) {
            NearVanillaShopDirectoryMod.LOGGER.error("Failed to create directory: {}", (Object)directory, (Object)e);
            throw new RuntimeException("Could not create required directories", e);
        }
    }

    public static boolean safeLoadCSV(Path csvPath) {
        boolean bl;
        if (!Files.exists(csvPath, new LinkOption[0])) {
            NearVanillaShopDirectoryMod.LOGGER.warn("CSV file does not exist: {}", (Object)csvPath);
            return false;
        }
        CSVParser parser = new CSVParser(csvPath);
        try {
            ShopLoader loader = new ShopLoader();
            int loadedCount = 0;
            int errorCount = 0;
            for (CsvRecord record : parser.parse()) {
                if (record.fieldCount() < 5) {
                    NearVanillaShopDirectoryMod.LOGGER.warn("Skipping invalid line {}: insufficient fields ({})", (Object)record.lineNumber(), (Object)record.fieldCount());
                    ++errorCount;
                    continue;
                }
                try {
                    ShopItem item = loader.parseShopItem(record);
                    ShopManager.addShopItem(item);
                    ++loadedCount;
                    NearVanillaShopDirectoryMod.LOGGER.debug("Loaded shop: {}", (Object)item.getShopName());
                }
                catch (IllegalArgumentException e) {
                    NearVanillaShopDirectoryMod.LOGGER.error("Error parsing line {}: {}. {}", new Object[]{record.lineNumber(), record.getField(0), e.getMessage()});
                    ++errorCount;
                }
            }
            NearVanillaShopDirectoryMod.LOGGER.info("CSV loading completed. Loaded: {}, Errors: {}", (Object)loadedCount, (Object)errorCount);
            bl = loadedCount > 0;
        }
        catch (Throwable throwable) {
            try {
                try {
                    parser.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                NearVanillaShopDirectoryMod.LOGGER.error("Error reading CSV file: {} - {}", (Object)csvPath, (Object)e.getMessage());
                return false;
            }
        }
        parser.close();
        return bl;
    }

    public static String readLocalVersion(Path versionFilePath) throws IOException {
        if (Files.exists(versionFilePath, new LinkOption[0])) {
            return Files.readString(versionFilePath).trim();
        }
        return null;
    }

    public static void updateVersionFile(Path versionFilePath, String version) throws IOException {
        Files.writeString(versionFilePath, (CharSequence)version, new OpenOption[0]);
        NearVanillaShopDirectoryMod.LOGGER.info("Updated version file with version: {}", (Object)version);
    }
}

