/*
 * Decompiled with CFR 0.152.
 */
package cyb0124;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;

public class NativeLoader {
    public static String ARCH = System.getProperty("os.arch").toLowerCase().trim();
    public static boolean IS_WINDOWS;

    public static native long allocPagesRW(long var0);

    public static native ByteBuffer wrapBuffer(long var0, long var2);

    public static native void setAndRunPagesRX(long var0, long var2, long var4, long var6, Object var8);

    static {
        if (ARCH.equals("x86_64") || ARCH.equals("amd64")) {
            ARCH = "x64";
        } else if (!ARCH.equals("aarch64")) {
            throw new UnsupportedOperationException("Unsupported architecture: " + ARCH);
        }
        String srcPath = "/NativeLoader-" + ARCH;
        String os = System.getProperty("os.name");
        if (os.startsWith("Linux")) {
            srcPath = srcPath + ".so";
        } else if (os.startsWith("Windows")) {
            srcPath = srcPath + ".dll";
            IS_WINDOWS = true;
        } else if (os.startsWith("Mac") || os.startsWith("Darwin")) {
            srcPath = srcPath + ".dylib";
        } else {
            throw new UnsupportedOperationException("Unsupported OS: " + os);
        }
        Path dstPath = Paths.get("natives" + srcPath, new String[0]).toAbsolutePath();
        try (InputStream is = NativeLoader.class.getResourceAsStream(srcPath);){
            Files.createDirectories(Paths.get("natives", new String[0]), new FileAttribute[0]);
            Files.write(dstPath, IOUtils.toByteArray((InputStream)is), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            LogManager.getLogger().error("Failed to extract native binary", (Throwable)e);
        }
        System.load(dstPath.toString());
    }
}

