/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.common;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import cyb0124.curvy_pipes.Mod;
import cyb0124.curvy_pipes.common.BuiltInPipeItem;
import cyb0124.curvy_pipes.common.CauldronAdapter;
import cyb0124.curvy_pipes.common.OutlineCapturer;
import cyb0124.curvy_pipes.common.SaveData;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.ForkJoinPool;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.io.IOUtils;

public class CommonHandler {
    private static Class<?>[] WRENCHES;

    private static native void loadConfig(String var0);

    private static native short[] creativeTabData();

    public static native void idMapped();

    private static native void loadLevel(WorldServer var0, int var1, long[] var2, byte[] var3, WorldSavedData var4);

    private static native void unloadLevel(WorldServer var0);

    static native byte[] saveLevel(WorldServer var0);

    private static native void chunkLoaded(WorldServer var0, int var1, int var2);

    private static native void chunkUnloaded(WorldServer var0, int var1, int var2);

    private static native void watchChunk(EntityPlayerMP var0, int var1, int var2);

    private static native void unwatchChunk(EntityPlayerMP var0, int var1, int var2);

    private static native void tick();

    private static native String[] getRecipes();

    private static native int useItem(int var0, int var1, boolean var2, boolean var3);

    private static native int getSignal(WorldServer var0, int var1, int var2, int var3, int var4, int var5);

    private static void queueWorker(Runnable task) {
        ForkJoinPool.commonPool().execute(task);
    }

    private static double[] getCollisionBoxes(WorldServer level, int cx, int cz, int x, int y, int z) {
        Chunk chunk = level.func_72863_F().func_186026_b(cx, cz);
        if (chunk == null) {
            return new double[0];
        }
        BlockPos pos = new BlockPos(x, y, z);
        ArrayList boxes = new ArrayList();
        chunk.func_186032_a(x, y, z).func_185908_a((World)level, pos, new AxisAlignedBB(pos), boxes, null, true);
        DoubleArrayList out = new DoubleArrayList();
        for (AxisAlignedBB box : boxes) {
            out.add(box.field_72340_a);
            out.add(box.field_72338_b);
            out.add(box.field_72339_c);
            out.add(box.field_72336_d);
            out.add(box.field_72337_e);
            out.add(box.field_72334_f);
        }
        return out.toDoubleArray();
    }

    private static double[] getOutlineBoxes(WorldServer level, int cx, int cz, int x, int y, int z) {
        Chunk chunk = level.func_72863_F().func_186026_b(cx, cz);
        if (chunk == null) {
            return new double[0];
        }
        return OutlineCapturer.run(cap -> cap.step((World)level, chunk.func_186032_a(x, y, z), new BlockPos(x, y, z)));
    }

    private static double playerReach(EntityPlayer player) {
        return player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
    }

    private static boolean isHoldingWrench(EntityPlayer player) {
        for (Class<?> wrench : WRENCHES) {
            if (wrench.isInstance(player.func_184614_ca().func_77973_b())) {
                return true;
            }
            if (!wrench.isInstance(player.func_184592_cb().func_77973_b())) continue;
            return true;
        }
        return false;
    }

    public static Stack<ItemStack> gatherStacks(EntityPlayer player, Item pItem, short meta) {
        ItemStack item = new ItemStack(pItem, 1, (int)meta);
        Stack<ItemStack> result = new Stack<ItemStack>();
        ItemStack selected = player.func_184607_cu();
        if (selected.func_77969_a(item)) {
            result.add(selected);
        }
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == selected || !stack.func_77969_a(item)) continue;
            result.add(stack);
        }
        for (ItemStack stack : player.field_71071_by.field_184439_c) {
            if (!stack.func_77969_a(item)) continue;
            result.add(stack);
        }
        return result;
    }

    public static int countStacks(Stack<ItemStack> stacks) {
        return stacks.stream().mapToInt(ItemStack::func_190916_E).sum();
    }

    private static void consumeStacks(EntityPlayer player, Stack<ItemStack> stacks, int count) {
        while (count != 0) {
            ItemStack top = stacks.peek();
            int avail = Math.min(top.func_190916_E(), count);
            top.func_190918_g(avail);
            if (top.func_190926_b()) {
                stacks.pop();
            }
            count -= avail;
        }
        player.field_71069_bz.func_75142_b();
    }

    private static void giveStack(EntityPlayer player, Item item, short meta, int qty) {
        ItemStack stack = new ItemStack(item, qty, (int)meta);
        if (player.field_71071_by.func_70441_a(stack)) {
            player.field_71069_bz.func_75142_b();
        }
        if (!stack.func_190926_b()) {
            player.func_71019_a(stack, true);
        }
    }

    private static void spawnStack(WorldServer level, Item item, short meta, int qty, double x, double y, double z) {
        EntityItem entity = new EntityItem((World)level, x, y, z, new ItemStack(item, qty, (int)meta));
        entity.func_174869_p();
        level.func_72838_d((Entity)entity);
    }

    public static ItemStack copyItemWithQty(ItemStack stack, int qty) {
        stack = stack.func_77946_l();
        stack.func_190920_e(qty);
        return stack;
    }

    public static int itemId(ItemStack stack) {
        return Item.func_150891_b((Item)stack.func_77973_b());
    }

    public static int itemMeta(ItemStack stack) {
        return Items.field_151008_G.getDamage(stack);
    }

    public static boolean isSameItemAndTag(ItemStack x, ItemStack y) {
        return x.func_77969_a(y) && ItemStack.func_77970_a((ItemStack)x, (ItemStack)y);
    }

    public static int itemTagHash(ItemStack stack) {
        return Objects.hashCode(stack.func_77978_p());
    }

    public static long fluidAndTagPreHash(FluidStack stack) {
        long lo = stack.getFluid().hashCode();
        long hi = Objects.hashCode(stack.tag);
        return hi << 32 | lo & 0xFFFFFFFFL;
    }

    public static FluidStack copyFluidWithQty(FluidStack stack, int qty) {
        stack = stack.copy();
        stack.amount = qty;
        return stack;
    }

    private static byte[] encodeItem(ItemStack stack) throws IOException {
        ByteArrayDataOutput data = ByteStreams.newDataOutput();
        CompressedStreamTools.func_74800_a((NBTTagCompound)stack.serializeNBT(), (DataOutput)data);
        return data.toByteArray();
    }

    private static ItemStack decodeItem(byte[] data) throws IOException {
        return new ItemStack(CompressedStreamTools.func_152456_a((DataInput)ByteStreams.newDataInput((byte[])data), (NBTSizeTracker)NBTSizeTracker.field_152451_a));
    }

    private static byte[] encodeFluid(FluidStack stack) throws IOException {
        NBTTagCompound tag = new NBTTagCompound();
        stack.writeToNBT(tag);
        ByteArrayDataOutput data = ByteStreams.newDataOutput();
        CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)data);
        return data.toByteArray();
    }

    private static FluidStack decodeFluid(byte[] data) throws IOException {
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)CompressedStreamTools.func_152456_a((DataInput)ByteStreams.newDataInput((byte[])data), (NBTSizeTracker)NBTSizeTracker.field_152451_a));
    }

    private static FluidStack fluidOfItem(ItemStack stack) {
        IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (cap == null) {
            return null;
        }
        for (IFluidTankProperties tank : cap.getTankProperties()) {
            FluidStack fluid = tank.getContents();
            if (fluid == null || fluid.amount <= 0) continue;
            return fluid;
        }
        return null;
    }

    private static IEnergyStorage resolveEnergyCap(WorldServer level, int cx, int cz, int x, int y, int z, byte dir) {
        Chunk chunk = level.func_72863_F().func_186026_b(cx, cz);
        if (chunk == null) {
            return null;
        }
        TileEntity tile = chunk.func_177424_a(new BlockPos(x, y, z), Chunk.EnumCreateEntityType.CHECK);
        if (tile == null) {
            return null;
        }
        return (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, EnumFacing.func_82600_a((int)dir));
    }

    private static IFluidHandler resolveFluidCap(WorldServer level, int cx, int cz, int x, int y, int z, byte dir) {
        Chunk chunk = level.func_72863_F().func_186026_b(cx, cz);
        if (chunk == null) {
            return null;
        }
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity tile = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
        if (tile != null) {
            return (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.func_82600_a((int)dir));
        }
        if (chunk.func_177435_g(pos).func_177230_c() == Blocks.field_150383_bp) {
            return new CauldronAdapter(chunk, pos);
        }
        return null;
    }

    public static int getSignal(int base, IBlockAccess level, BlockPos pos, EnumFacing dir) {
        if (base >= 15) {
            return base;
        }
        if (!(level instanceof WorldServer)) {
            return base;
        }
        if (!Blocks.field_150488_af.func_176223_P().func_185897_m()) {
            return base;
        }
        return Math.max(base, CommonHandler.getSignal((WorldServer)level, System.identityHashCode(level), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dir.func_176745_a()));
    }

    private static int getSignal(WorldServer level, int x, int y, int z, byte dir) {
        BlockPos pos = new BlockPos(x, y, z);
        int signal = level.func_175651_c(new BlockPos(x, y, z), EnumFacing.func_82600_a((int)dir));
        if (signal >= 14) {
            return signal;
        }
        IBlockState state = level.func_180495_p(pos);
        if (state.func_177230_c() != Blocks.field_150488_af) {
            return signal;
        }
        return Math.max(signal, (Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O) - 1);
    }

    private static void updateNeighbors(WorldServer level, int x0, int y0, int z0, int x1, int y1, int z1) {
        BlockPos p0 = new BlockPos(x0, y0, z0);
        BlockPos p1 = new BlockPos(x1, y1, z1);
        level.func_190524_a(p0, level.func_180495_p(p1).func_177230_c(), p1);
        level.func_175685_c(p0, level.func_180495_p(p0).func_177230_c(), false);
    }

    @SubscribeEvent
    public static void onLevelLoad(WorldEvent.Load evt) {
        World w = evt.getWorld();
        if (!(w instanceof WorldServer)) {
            return;
        }
        WorldServer level = (WorldServer)w;
        MapStorage storage = level.getPerWorldStorage();
        SaveData data = (SaveData)storage.func_75742_a(SaveData.class, "curvy_pipes");
        if (data == null) {
            data = new SaveData("curvy_pipes");
            storage.func_75745_a("curvy_pipes", (WorldSavedData)data);
        }
        data.level = level;
        CommonHandler.loadLevel(level, level.field_73011_w.getDimension(), level.func_72863_F().field_73244_f.keySet().toLongArray(), data.toLoad, data);
        data.toLoad = null;
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load evt) {
        World w = evt.getWorld();
        if (!(w instanceof WorldServer)) {
            return;
        }
        Chunk chunk = evt.getChunk();
        CommonHandler.chunkLoaded((WorldServer)w, chunk.field_76635_g, chunk.field_76647_h);
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload evt) {
        World w = evt.getWorld();
        if (!(w instanceof WorldServer)) {
            return;
        }
        Chunk chunk = evt.getChunk();
        CommonHandler.chunkUnloaded((WorldServer)w, chunk.field_76635_g, chunk.field_76647_h);
    }

    @SubscribeEvent
    public static void onLevelUnload(WorldEvent.Unload evt) {
        World w = evt.getWorld();
        CommonHandler.unloadLevel(w instanceof WorldServer ? (WorldServer)w : null);
    }

    @SubscribeEvent
    public static void onChunkWatch(ChunkWatchEvent.Watch evt) {
        ChunkPos chunk = evt.getChunk();
        CommonHandler.watchChunk(evt.getPlayer(), chunk.field_77276_a, chunk.field_77275_b);
    }

    @SubscribeEvent
    public static void onChunkUnwatch(ChunkWatchEvent.UnWatch evt) {
        ChunkPos chunk = evt.getChunk();
        CommonHandler.unwatchChunk(evt.getPlayer(), chunk.field_77276_a, chunk.field_77275_b);
    }

    public static void loadConfig() {
        String config;
        String defaultConfig;
        Path configDir = Loader.instance().getConfigDir().toPath();
        Path defaultPath = configDir.resolve("curvy_pipes_default.yaml");
        Path path = configDir.resolve("curvy_pipes.yaml");
        try (InputStream is = Mod.class.getResourceAsStream("/default.yaml");){
            defaultConfig = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            Files.write(defaultPath, defaultConfig.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        try {
            config = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            config = defaultConfig;
        }
        CommonHandler.loadConfig(config);
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> evt) {
        final short[] tabData = CommonHandler.creativeTabData();
        CreativeTabs tab = tabData == null ? null : new CreativeTabs("curvy_pipes"){

            public ItemStack func_78016_d() {
                return new ItemStack((Item)BuiltInPipeItem.INST, 1, (int)tabData[0]);
            }
        };
        new BuiltInPipeItem((IForgeRegistry<Item>)evt.getRegistry(), tab, tabData);
    }

    @SubscribeEvent
    public static void onRegisterRecipes(RegistryEvent.Register<IRecipe> evt) {
        Gson gson = new Gson();
        JsonContext ctx = new JsonContext("curvy_pipes");
        String[] recipes = CommonHandler.getRecipes();
        for (int i = 0; i != recipes.length; i += 2) {
            try {
                IRecipe recipe = CraftingHelper.getRecipe((JsonObject)((JsonObject)gson.fromJson(recipes[i + 1], JsonObject.class)), (JsonContext)ctx);
                recipe.setRegistryName(new ResourceLocation("curvy_pipes", recipes[i]));
                evt.getRegistry().register((IForgeRegistryEntry)recipe);
                continue;
            }
            catch (Throwable e) {
                Mod.LOGGER.error("Failed to apply recipe " + recipes[i], e);
            }
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END) {
            CommonHandler.tick();
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock evt) {
        ItemStack stack = evt.getItemStack();
        if (CommonHandler.useItem(CommonHandler.itemId(stack), CommonHandler.itemMeta(stack), evt.getHand() == EnumHand.OFF_HAND, false) != 0) {
            evt.setUseItem(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem evt) {
        ItemStack stack = evt.getItemStack();
        int result = CommonHandler.useItem(CommonHandler.itemId(stack), CommonHandler.itemMeta(stack), evt.getHand() == EnumHand.OFF_HAND, evt.getSide().isClient());
        if (result != 0) {
            evt.setCanceled(true);
            evt.setCancellationResult(result == 1 ? EnumActionResult.SUCCESS : EnumActionResult.FAIL);
        }
    }
}

