/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.compat;

import appeng.api.config.Actionable;
import appeng.api.exceptions.FailedConnectionException;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergyGridProvider;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEColoredItemDefinition;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.core.Api;
import appeng.core.api.definitions.ApiParts;
import cyb0124.curvy_pipes.common.BuiltInPipeItem;
import cyb0124.curvy_pipes.common.CommonHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import java.util.function.IntConsumer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class AEPlugin {
    private static native void addCable(int var0, int var1, String var2, Item var3, int var4, String var5);

    private static native void markBlock(World var0, int var1, int var2, int var3, int var4);

    public static void markBlock(IGridNode node) {
        DimensionalCoord loc = node.getGridBlock().getLocation();
        World level = loc.getWorld();
        if (level.func_189509_E(new BlockPos((Vec3i)loc.getPos()))) {
            return;
        }
        AEPlugin.markBlock(level, System.identityHashCode(level), loc.x, loc.y, loc.z);
    }

    private static void addCables(int type, String key, AEColoredItemDefinition item, String sprite) {
        for (AEColor color : AEColor.values()) {
            String suffix = color.name().toLowerCase(Locale.ROOT);
            ItemStack stack = item.stack(color, 1);
            AEPlugin.addCable(type, color.whiteVariant, key + "!" + suffix, stack.func_77973_b(), CommonHandler.itemMeta(stack), "appliedenergistics2:" + sprite + "/" + suffix);
        }
    }

    private static void addCables() {
        ApiParts parts = Api.INSTANCE.definitions().parts();
        ItemStack fiber = (ItemStack)parts.quartzFiber().maybeStack(1).get();
        AEPlugin.addCable(0, 0, "quartzFiber", fiber.func_77973_b(), CommonHandler.itemMeta(fiber), "appliedenergistics2:items/part/quartz_fiber");
        AEPlugin.addCables(1, "cableGlass", parts.cableGlass(), "parts/cable/glass");
        AEPlugin.addCables(2, "cableCovered", parts.cableCovered(), "parts/cable/covered");
        AEPlugin.addCables(3, "cableSmart", parts.cableSmart(), "parts/cable/smart");
        AEPlugin.addCables(4, "cableDenseCovered", parts.cableDenseCovered(), "parts/cable/dense_covered");
        AEPlugin.addCables(5, "cableDenseSmart", parts.cableDenseSmart(), "parts/cable/dense_smart");
    }

    private static IGridNode addNode(WorldServer level, Item pipe, IntConsumer setOverlayIdx, byte capacity, short meta, boolean joint) {
        IGridNode node = new NodeOwner((WorldServer)level, (ItemStack)BuiltInPipeItem.INST.makeIcon((Item)pipe, (short)meta, (boolean)joint), (IntConsumer)setOverlayIdx, (GridFlags)(capacity == 0 ? GridFlags.CANNOT_CARRY : (capacity == 1 ? GridFlags.PREFERRED : GridFlags.DENSE_CAPACITY))).node;
        node.updateState();
        return node;
    }

    private static IGridNode[] addEnergyPair(WorldServer level, Item pipe, short meta) {
        ItemStack icon = BuiltInPipeItem.INST.makeIcon(pipe, meta, false);
        EnergyNodeOwner x = new EnergyNodeOwner(level, icon);
        EnergyNodeOwner y = new EnergyNodeOwner(level, icon);
        x.peer = y.node;
        y.peer = x.node;
        x.node.updateState();
        y.node.updateState();
        return new IGridNode[]{x.node, y.node};
    }

    private static void addNodeConn(IGridNode x, IGridNode y) {
        for (IGridConnection c : x.getConnections()) {
            if (c.a() != y && c.b() != y) continue;
            return;
        }
        try {
            Api.INSTANCE.grid().createGridConnection(x, y);
        }
        catch (FailedConnectionException failedConnectionException) {
            // empty catch block
        }
    }

    private static void addBlockConn(IGridNode node, WorldServer level, int cx, int cz, int x, int y, int z, byte rawDir, boolean ext) {
        IPartHost host;
        Chunk chunk = level.func_72863_F().func_186026_b(cx, cz);
        if (chunk == null) {
            return;
        }
        TileEntity tile = chunk.func_177424_a(new BlockPos(x, y, z), Chunk.EnumCreateEntityType.CHECK);
        if (tile instanceof IPartHost) {
            host = (IPartHost)tile;
            IPart part = host.getPart(AEPartLocation.fromOrdinal((int)rawDir));
            if (part == null) {
                part = host.getPart(AEPartLocation.INTERNAL);
            }
            if (part != null) {
                IGridNode peer;
                IGridNode iGridNode = peer = ext ? part.getExternalFacingNode() : part.getGridNode();
                if (peer != null) {
                    AEPlugin.addNodeConn(node, peer);
                    return;
                }
            }
        }
        if (tile instanceof IGridHost) {
            host = (IGridHost)tile;
            IGridNode peer = host.getGridNode(AEPartLocation.fromOrdinal((int)rawDir));
            if (peer == null) {
                peer = host.getGridNode(AEPartLocation.INTERNAL);
            }
            if (peer != null) {
                AEPlugin.addNodeConn(node, peer);
            }
        }
    }

    public static class EnergyNodeOwner
    extends NodeOwner
    implements IEnergyGridProvider {
        private IGridNode peer;

        private EnergyNodeOwner(WorldServer level, ItemStack icon) {
            super(level, icon, null, GridFlags.CANNOT_CARRY);
        }

        public Collection<IEnergyGridProvider> providers() {
            return Arrays.asList((IEnergyGridProvider)this.node.getGrid().getCache(IEnergyGrid.class), (IEnergyGridProvider)this.peer.getGrid().getCache(IEnergyGrid.class));
        }

        public double extractProviderPower(double v, Actionable m) {
            return 0.0;
        }

        public double injectProviderPower(double v, Actionable m) {
            return 0.0;
        }

        public double getProviderEnergyDemand(double v) {
            return 0.0;
        }

        public double getProviderStoredEnergy() {
            return 0.0;
        }

        public double getProviderMaxEnergy() {
            return 0.0;
        }
    }

    public static class NodeOwner
    implements IGridBlock,
    IGridHost {
        private final EnumSet<GridFlags> flags;
        private final DimensionalCoord coord;
        private final ItemStack icon;
        private final IntConsumer setOverlayIdx;
        protected final IGridNode node;
        private int lastOverlayIdx;

        private NodeOwner(WorldServer level, ItemStack icon, IntConsumer setOverlayIdx, GridFlags flag) {
            this.flags = EnumSet.of(flag);
            this.coord = new DimensionalCoord((World)level, 0, -268435456, 0);
            this.icon = icon;
            this.setOverlayIdx = setOverlayIdx;
            this.node = Api.INSTANCE.grid().createGridNode((IGridBlock)this);
        }

        private void updateOverlay() {
            if (this.setOverlayIdx == null) {
                return;
            }
            int overlayIdx = 0;
            IEnergyGrid energy = (IEnergyGrid)this.node.getGrid().getCache(IEnergyGrid.class);
            if (energy.isNetworkPowered()) {
                for (IGridConnection c : this.node.getConnections()) {
                    overlayIdx = Math.max(overlayIdx, c.getUsedChannels());
                }
            }
            if (this.lastOverlayIdx == overlayIdx) {
                return;
            }
            this.lastOverlayIdx = overlayIdx;
            this.setOverlayIdx.accept(overlayIdx);
        }

        @MENetworkEventSubscribe
        public void channelChanged(MENetworkChannelsChanged ignored) {
            this.updateOverlay();
        }

        @MENetworkEventSubscribe
        public void powerChanged(MENetworkPowerStatusChange ignored) {
            this.updateOverlay();
        }

        public double getIdlePowerUsage() {
            return 0.0;
        }

        public EnumSet<GridFlags> getFlags() {
            return this.flags;
        }

        public boolean isWorldAccessible() {
            return false;
        }

        public DimensionalCoord getLocation() {
            return this.coord;
        }

        public AEColor getGridColor() {
            return AEColor.TRANSPARENT;
        }

        public void onGridNotification(GridNotification notification) {
        }

        public void setNetworkStatus(IGrid grid, int count) {
        }

        public EnumSet<EnumFacing> getConnectableSides() {
            return EnumSet.noneOf(EnumFacing.class);
        }

        public IGridHost getMachine() {
            return this;
        }

        public void gridChanged() {
        }

        public ItemStack getMachineRepresentation() {
            return this.icon;
        }

        public IGridNode getGridNode(AEPartLocation location) {
            return this.node;
        }

        public AECableType getCableConnectionType(AEPartLocation location) {
            return AECableType.NONE;
        }

        public void securityBreak() {
        }
    }
}

