/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.compat;

import cyb0124.curvy_pipes.compat.GTEnergyWrapper;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.fluids.FluidState;
import gregtech.api.fluids.attribute.AttributedFluid;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.pipenet.block.IPipeType;
import gregtech.api.pipenet.block.material.BlockMaterialPipe;
import gregtech.api.pipenet.block.material.IMaterialPipeType;
import gregtech.api.pipenet.block.material.ItemBlockMaterialPipe;
import gregtech.api.recipes.ModHandler;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.FluidPipeProperties;
import gregtech.api.unification.material.registry.MaterialRegistry;
import gregtech.common.metatileentities.converter.ConverterTrait;
import gregtech.common.pipelike.cable.BlockCable;
import gregtech.common.pipelike.cable.ItemBlockCable;
import gregtech.common.pipelike.fluidpipe.BlockFluidPipe;
import gregtech.common.pipelike.fluidpipe.ItemBlockFluidPipe;
import gregtech.common.pipelike.itempipe.BlockItemPipe;
import gregtech.common.pipelike.itempipe.ItemBlockItemPipe;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class GTPlugin {
    private static native void addCable(PipeMeta var0, int var1, int var2, int var3);

    private static native void addItemPipe(PipeMeta var0, float var1);

    private static native void addFluidPipe(PipeMeta var0, int var1, Predicate<FluidStack> var2);

    static native long acceptEnergy(WorldServer var0, int var1, int var2, int var3, int var4, int var5, long var6, long var8);

    static native boolean canAcceptEnergy(WorldServer var0, int var1, int var2, int var3, int var4, int var5);

    public static IEnergyContainer wrapEnergyContainer(TileEntity neighbor, EnumFacing opposite, MetaTileEntity mte) {
        IEnergyContainer inner = neighbor == null ? null : (IEnergyContainer)neighbor.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, opposite);
        World level = mte.getWorld();
        if (!(level instanceof WorldServer)) {
            return inner;
        }
        BlockPos pos = mte.getPos();
        if (pos == null) {
            return inner;
        }
        return new GTEnergyWrapper(inner, (WorldServer)level, pos);
    }

    public static IEnergyContainer wrapEnergyConverter(IEnergyContainer inner, ConverterTrait converter) {
        MetaTileEntity mte = converter.getMetaTileEntity();
        World level = mte.getWorld();
        if (!(level instanceof WorldServer)) {
            return inner;
        }
        BlockPos pos = mte.getPos();
        if (pos == null) {
            return inner;
        }
        return new GTEnergyWrapper(inner, (WorldServer)level, pos);
    }

    private static IEnergyContainer resolveEnergySink(WorldServer level, int cx, int cz, int x, int y, int z, byte pDir) {
        Chunk chunk = level.func_72863_F().func_186026_b(cx, cz);
        if (chunk == null) {
            return null;
        }
        TileEntity tile = chunk.func_177424_a(new BlockPos(x, y, z), Chunk.EnumCreateEntityType.CHECK);
        if (tile == null) {
            return null;
        }
        EnumFacing dir = EnumFacing.func_82600_a((int)pDir);
        IEnergyContainer inner = (IEnergyContainer)tile.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, dir);
        return inner == null || !inner.inputsEnergy(dir) ? null : inner;
    }

    private static long sinkEnergy(IEnergyContainer sink, byte dir, long volts, long amps) {
        return sink.acceptEnergyFromNetwork(EnumFacing.func_82600_a((int)dir), volts, amps);
    }

    private static <T, U extends Enum<U>> void addPipes(ItemBlockMaterialPipe<U, T> item, BlockMaterialPipe<U, T, ?> block, Collection<Material> mats, PipeConsumer<T, U> consumer) {
        MaterialRegistry reg = block.getMaterialRegistry();
        for (Material mat : mats) {
            PipeMeta meta = new PipeMeta();
            meta.item = item;
            meta.meta = reg.func_148757_b((Object)mat);
            ItemStack stack = new ItemStack(meta.item, 1, meta.meta);
            Enum type = block.getItemPipeType(stack);
            meta.key = ((IMaterialPipeType)type).getOrePrefix().name + "!" + mat.getRegistryName();
            meta.thickness = ((IPipeType)type).getThickness();
            meta.rgb = mat.getMaterialRGB();
            meta.visual = ModHandler.isMaterialWood((Material)mat) ? 1 : 0;
            consumer.accept(meta, block.createItemProperties(stack), type);
        }
    }

    public static <T, U extends Enum<U>> void addPipes(ItemBlockMaterialPipe<U, T> item, int types) {
        if (item instanceof ItemBlockCable) {
            if ((types & 1) == 0) {
                return;
            }
            BlockCable block = (BlockCable)item.func_179223_d();
            GTPlugin.addPipes((ItemBlockCable)item, block, block.getEnabledMaterials(), (meta, props, type) -> {
                meta.visual = type.isCable() ? 3 : 2;
                GTPlugin.addCable(meta, props.getVoltage(), props.getAmperage(), props.getLossPerBlock());
            });
        } else if (item instanceof ItemBlockItemPipe) {
            if ((types & 2) == 0) {
                return;
            }
            BlockItemPipe block = (BlockItemPipe)item.func_179223_d();
            GTPlugin.addPipes((ItemBlockItemPipe)item, block, block.getEnabledMaterials(), (meta, props, type) -> GTPlugin.addItemPipe(meta, props.getTransferRate()));
        } else if (item instanceof ItemBlockFluidPipe) {
            if ((types & 4) == 0) {
                return;
            }
            BlockFluidPipe block = (BlockFluidPipe)item.func_179223_d();
            GTPlugin.addPipes((ItemBlockFluidPipe)item, block, block.getEnabledMaterials(), (meta, props, type) -> GTPlugin.addFluidPipe(meta, props.getThroughput(), stack -> {
                Fluid fluid = stack.getFluid();
                AttributedFluid gtFluid = fluid instanceof AttributedFluid ? (AttributedFluid)fluid : null;
                int temp = fluid.getTemperature(stack);
                if (props.getMaxFluidTemperature() < temp) {
                    if (gtFluid == null) return true;
                    if (gtFluid.getState() != FluidState.PLASMA) return true;
                }
                if (!props.isGasProof()) {
                    if (fluid.isGaseous(stack)) return true;
                }
                if (!props.isCryoProof()) {
                    if (temp < 120) return true;
                }
                if (gtFluid == null) return false;
                if (!props.canContain(gtFluid.getState())) return true;
                if (gtFluid.getAttributes().stream().allMatch(arg_0 -> ((FluidPipeProperties)props).canContain(arg_0))) return false;
                return true;
            }));
        }
    }

    private static interface PipeConsumer<T, U> {
        public void accept(PipeMeta var1, T var2, U var3);
    }

    private static class PipeMeta {
        private Item item;
        private int meta;
        private String key;
        private float thickness;
        private int rgb;
        private int visual;

        private PipeMeta() {
        }
    }
}

