/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.inv;

import cyb0124.curvy_pipes.common.CommonHandler;
import cyb0124.curvy_pipes.inv.Typical;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

abstract class FluidInv<T>
extends Typical<T> {
    protected FluidStack[] fluids;
    protected long[] hashes;

    protected FluidInv(T inner, boolean split) {
        super(inner, split);
    }

    private static FluidInv<?> resolve(WorldServer level, int cx, int cz, int x, int y, int z, byte dir) {
        Chunk chunk = level.func_72863_F().func_186026_b(cx, cz);
        if (chunk == null) {
            return null;
        }
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity tile = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
        if (tile != null) {
            IFluidHandler cap = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.func_82600_a((int)dir));
            return cap == null ? null : new Cap(cap);
        }
        if (chunk.func_177435_g(pos).func_177230_c() == Blocks.field_150383_bp) {
            return new Cauldron(chunk, pos);
        }
        return null;
    }

    protected abstract void read();

    protected abstract int fill(FluidStack var1, int var2, boolean var3);

    protected abstract int drain(FluidStack var1, int var2, boolean var3);

    protected abstract FluidStack drain();

    private static class Cauldron
    extends FluidInv<Void> {
        private final Chunk chunk;
        private final BlockPos pos;

        private Cauldron(Chunk chunk, BlockPos pos) {
            super(null, false);
            this.chunk = chunk;
            this.pos = pos;
        }

        private Fluid readPriv() {
            IBlockState state = this.chunk.func_177435_g(this.pos);
            if (state.func_177230_c() != Blocks.field_150383_bp) {
                return null;
            }
            if ((Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a) < 3) {
                return null;
            }
            return FluidRegistry.WATER;
        }

        @Override
        protected void read() {
            Fluid fluid = this.readPriv();
            if (fluid == null) {
                return;
            }
            this.fluids = new FluidStack[]{new FluidStack(fluid, 1)};
            this.hashes = new long[]{fluid.hashCode(), 1000L};
        }

        @Override
        protected int fill(FluidStack fluid, int qty, boolean exec) {
            if (qty < 1000 || fluid.getFluid() != FluidRegistry.WATER) {
                return 0;
            }
            IBlockState state = this.chunk.func_177435_g(this.pos);
            if (state.func_177230_c() != Blocks.field_150383_bp || (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a) > 0) {
                return 0;
            }
            if (exec) {
                Blocks.field_150383_bp.func_176590_a(this.chunk.func_177412_p(), this.pos, state, 3);
            }
            return 1000;
        }

        @Override
        protected int drain(FluidStack fluid, int qty, boolean exec) {
            if (qty < 1000 || fluid.getFluid() != FluidRegistry.WATER) {
                return 0;
            }
            IBlockState state = this.chunk.func_177435_g(this.pos);
            if (state.func_177230_c() != Blocks.field_150383_bp || (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a) < 3) {
                return 0;
            }
            if (exec) {
                Blocks.field_150383_bp.func_176590_a(this.chunk.func_177412_p(), this.pos, state, 0);
            }
            return 1000;
        }

        @Override
        protected FluidStack drain() {
            Fluid fluid = this.readPriv();
            return fluid == null ? null : new FluidStack(fluid, 1000);
        }
    }

    private static class Cap
    extends FluidInv<IFluidHandler> {
        private Cap(IFluidHandler inner) {
            super(inner, true);
        }

        @Override
        protected void read() {
            IFluidTankProperties[] tanks = ((IFluidHandler)this.inner).getTankProperties();
            int nTanks = tanks.length;
            this.fluids = new FluidStack[nTanks];
            this.hashes = new long[nTanks * 2];
            for (int i = 0; i != nTanks; ++i) {
                FluidStack stack = tanks[i].getContents();
                if (stack == null || stack.amount <= 0) continue;
                this.fluids[i] = stack.copy();
                this.hashes[i * 2] = CommonHandler.fluidAndTagPreHash(stack);
                this.hashes[i * 2 + 1] = stack.amount;
            }
        }

        @Override
        protected int fill(FluidStack fluid, int qty, boolean exec) {
            return ((IFluidHandler)this.inner).fill(CommonHandler.copyFluidWithQty(fluid, qty), exec);
        }

        @Override
        protected int drain(FluidStack fluid, int qty, boolean exec) {
            FluidStack out = ((IFluidHandler)this.inner).drain(CommonHandler.copyFluidWithQty(fluid, qty), exec);
            return out == null ? 0 : out.amount;
        }

        @Override
        protected FluidStack drain() {
            FluidStack out = ((IFluidHandler)this.inner).drain(Integer.MAX_VALUE, false);
            return out != null && out.amount > 0 ? out.copy() : null;
        }
    }
}

