/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.inv;

import cyb0124.curvy_pipes.common.CommonHandler;
import cyb0124.curvy_pipes.inv.Typical;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

abstract class FluidInv<T>
extends Typical<T> {
    protected FluidStack[] fluids;
    protected long[] hashes;

    protected FluidInv(T inner, boolean split) {
        super(inner, split);
    }

    private static FluidInv<?> resolve(ServerLevel level, int cx, int cz, int x, int y, int z, byte dir) {
        LevelChunk chunk = level.m_7726_().m_7131_(cx, cz);
        if (chunk == null) {
            return null;
        }
        BlockPos pos = new BlockPos(x, y, z);
        BlockEntity tile = chunk.m_7702_(pos);
        if (tile != null) {
            return tile.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.m_122376_((int)dir)).map(Cap::new).orElse(null);
        }
        if (chunk.m_8055_(pos).m_60734_() instanceof AbstractCauldronBlock) {
            return new Cauldron(chunk, pos);
        }
        return null;
    }

    protected abstract void read();

    protected abstract int fill(FluidStack var1, int var2, boolean var3);

    protected abstract int drain(FluidStack var1, int var2, boolean var3);

    protected abstract FluidStack drain();

    private static class Cauldron
    extends FluidInv<Void> {
        private final LevelChunk chunk;
        private final BlockPos pos;

        private Cauldron(LevelChunk chunk, BlockPos pos) {
            super(null, false);
            this.chunk = chunk;
            this.pos = pos;
        }

        private Fluid readPriv() {
            BlockState state = this.chunk.m_8055_(this.pos);
            if (state.m_60713_(Blocks.f_152477_)) {
                return Fluids.f_76195_;
            }
            if (state.m_60713_(Blocks.f_152476_) && (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) >= 3) {
                return Fluids.f_76193_;
            }
            return null;
        }

        @Override
        protected void read() {
            Fluid fluid = this.readPriv();
            if (fluid == null) {
                return;
            }
            this.fluids = new FluidStack[]{new FluidStack(fluid, 1)};
            this.hashes = new long[]{fluid.hashCode(), 1000L};
        }

        @Override
        protected int fill(FluidStack pFluid, int qty, boolean sim) {
            if (qty < 1000) {
                return 0;
            }
            if (!this.chunk.m_8055_(this.pos).m_60713_(Blocks.f_50256_)) {
                return 0;
            }
            Fluid fluid = pFluid.getFluid();
            if (fluid.m_6212_((Fluid)Fluids.f_76195_)) {
                if (!sim) {
                    this.chunk.m_62953_().m_7731_(this.pos, Blocks.f_152477_.m_49966_(), 3);
                }
            } else if (fluid.m_6212_((Fluid)Fluids.f_76193_)) {
                if (!sim) {
                    this.chunk.m_62953_().m_7731_(this.pos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), 3);
                }
            } else {
                return 0;
            }
            return 1000;
        }

        @Override
        protected int drain(FluidStack fluid, int qty, boolean sim) {
            if (qty < 1000) {
                return 0;
            }
            Fluid avail = this.readPriv();
            if (avail == null || !avail.m_6212_(fluid.getFluid())) {
                return 0;
            }
            if (!sim) {
                this.chunk.m_62953_().m_7731_(this.pos, Blocks.f_50256_.m_49966_(), 3);
            }
            return 1000;
        }

        @Override
        protected FluidStack drain() {
            Fluid fluid = this.readPriv();
            return fluid == null ? null : new FluidStack(fluid, 1000);
        }
    }

    private static class Cap
    extends FluidInv<IFluidHandler> {
        private Cap(IFluidHandler inner) {
            super(inner, true);
        }

        @Override
        protected void read() {
            int nTanks = ((IFluidHandler)this.inner).getTanks();
            this.fluids = new FluidStack[nTanks];
            this.hashes = new long[nTanks * 2];
            for (int i = 0; i != nTanks; ++i) {
                FluidStack stack = ((IFluidHandler)this.inner).getFluidInTank(i);
                if (stack.getAmount() <= 0) continue;
                this.fluids[i] = stack.copy();
                this.hashes[i * 2] = CommonHandler.fluidAndTagPreHash(stack);
                this.hashes[i * 2 + 1] = stack.getAmount();
            }
        }

        @Override
        protected int fill(FluidStack fluid, int qty, boolean sim) {
            return ((IFluidHandler)this.inner).fill(CommonHandler.copyFluidWithQty(fluid, qty), sim ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        }

        @Override
        protected int drain(FluidStack fluid, int qty, boolean sim) {
            return ((IFluidHandler)this.inner).drain(CommonHandler.copyFluidWithQty(fluid, qty), sim ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE).getAmount();
        }

        @Override
        protected FluidStack drain() {
            FluidStack out = ((IFluidHandler)this.inner).drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
            return out.getAmount() > 0 ? out.copy() : null;
        }
    }
}

