/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.client;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import cyb0124.curvy_pipes.client.PipeRenderTypes;
import cyb0124.curvy_pipes.common.CommonHandler;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.nio.FloatBuffer;
import java.util.function.Consumer;
import net.irisshaders.iris.shadows.ShadowRenderer;
import net.irisshaders.iris.vertices.ImmediateState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;
import org.joml.Matrix4f;
import org.lwjgl.BufferUtils;

public class ClientHandler {
    private static boolean TRY_IRIS = true;
    static final FloatBuffer TRANSFORMS = BufferUtils.createFloatBuffer((int)32);
    static MeshData MESH;

    private static native void loadSprites(TextureAtlas var0);

    static native void renderPipeItem(int var0, int var1, int var2, int var3);

    private static native void renderLevel(double var0, double var2, double var4, boolean var6, boolean var7, int var8, int var9, int var10, int var11, double var12, float var14, int var15, int var16);

    private static native void renderTranslucent();

    private static native void renderGui(GuiGraphics var0);

    private static native void tick();

    private static native boolean interact(HitResult var0, boolean var1);

    static native Item[] customRenderItems();

    public static MeshData.DrawState makeDrawState(int nVertices, int nIndices, int format) {
        return new MeshData.DrawState(switch (format) {
            case 0 -> DefaultVertexFormat.NEW_ENTITY;
            case 1 -> DefaultVertexFormat.BLOCK;
            case 2 -> DefaultVertexFormat.POSITION_COLOR;
            default -> DefaultVertexFormat.POSITION_TEX;
        }, nVertices, nIndices, VertexFormat.Mode.TRIANGLES, VertexFormat.IndexType.INT);
    }

    private static boolean disableIrisFormat() {
        boolean wasExtended = false;
        if (TRY_IRIS) {
            try {
                wasExtended = ImmediateState.renderWithExtendedVertexFormat;
                ImmediateState.renderWithExtendedVertexFormat = false;
            }
            catch (NoClassDefFoundError ignored) {
                TRY_IRIS = false;
            }
        }
        return wasExtended;
    }

    private static VertexBuffer makeBuffer() {
        boolean wasExtended = ClientHandler.disableIrisFormat();
        VertexBuffer vb = new VertexBuffer(VertexBuffer.Usage.STATIC);
        vb.bind();
        vb.upload(MESH);
        VertexBuffer.unbind();
        if (wasExtended) {
            ImmediateState.renderWithExtendedVertexFormat = true;
        }
        return vb;
    }

    private static void drawBuffer(VertexBuffer vb) {
        RenderType type = PipeRenderTypes.CUTOUT;
        type.setupRenderState();
        vb.bind();
        TRANSFORMS.position(0);
        Matrix4f proj = new Matrix4f(TRANSFORMS);
        TRANSFORMS.position(16);
        Matrix4f pose = new Matrix4f(TRANSFORMS);
        float oldFog = RenderSystem.getShaderFogStart();
        RenderSystem.setShaderFogStart((float)Float.MAX_VALUE);
        vb.drawWithShader(pose, proj, RenderSystem.getShader());
        RenderSystem.setShaderFogStart((float)oldFog);
        VertexBuffer.unbind();
        type.clearRenderState();
    }

    private static void drawImmediate(RenderType type) {
        boolean wasExtended = ClientHandler.disableIrisFormat();
        type.setupRenderState();
        BufferUploader.drawWithShader((MeshData)MESH);
        type.clearRenderState();
        if (wasExtended) {
            ImmediateState.renderWithExtendedVertexFormat = true;
        }
    }

    private static void drawImmediate(int type) {
        ClientHandler.drawImmediate(switch (type) {
            case 0 -> PipeRenderTypes.CUTOUT;
            case 1 -> Sheets.translucentCullBlockSheet();
            default -> PipeRenderTypes.GUI;
        });
    }

    private static void drawCrumble(float pct) {
        int n = ModelBakery.DESTROY_TYPES.size();
        ClientHandler.drawImmediate((RenderType)ModelBakery.DESTROY_TYPES.get(Math.min((int)(pct * (float)n), n - 1)));
    }

    private static void spawnPipeEffects(double[] coords, SoundEvent sound, Consumer<Vec3> makeParticle) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        Vec3 bestPos = null;
        double bestDist = 0.0;
        int i = 0;
        while (i != coords.length) {
            Vec3 pos = new Vec3(coords[i++], coords[i++], coords[i++]);
            double dist = pos.distanceToSqr(mc.player.position());
            if (bestPos == null || dist < bestDist) {
                bestPos = pos;
                bestDist = dist;
            }
            makeParticle.accept(pos);
        }
        mc.level.playLocalSound(bestPos.x, bestPos.y, bestPos.z, sound, SoundSource.BLOCKS, 1.0f, 1.0f, false);
    }

    private static void spawnBreakEffects(double[] coords, final float u0, final float v0, final float u1, final float v1, float r, float g, float b) {
        ClientHandler.spawnPipeEffects(coords, SoundEvents.STONE_BREAK, pos -> {
            Minecraft mc = Minecraft.getInstance();
            TerrainParticle particle = new TerrainParticle(mc.level, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0, Blocks.STONE.defaultBlockState()){
                final float uRand;
                final float vRand;
                {
                    super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
                    this.uRand = this.random.nextFloat() * 3.0f;
                    this.vRand = this.random.nextFloat() * 3.0f;
                }

                protected float getU0() {
                    return u0 + (u1 - u0) * (this.uRand + 1.0f) / 4.0f;
                }

                protected float getV0() {
                    return v0 + (v1 - v0) * this.vRand / 4.0f;
                }

                protected float getU1() {
                    return u0 + (u1 - u0) * this.uRand / 4.0f;
                }

                protected float getV1() {
                    return v0 + (v1 - v0) * (this.vRand + 1.0f) / 4.0f;
                }
            };
            particle.setColor(r, g, b);
            mc.particleEngine.add((Particle)particle);
        });
    }

    private static void spawnBurnEffects(double[] coords) {
        ClientHandler.spawnPipeEffects(coords, SoundEvents.LAVA_EXTINGUISH, pos -> Minecraft.getInstance().level.addParticle((ParticleOptions)ParticleTypes.LAVA, pos.x, pos.y, pos.z, 0.0, 5.0E-5, 0.0));
    }

    private static void swingHand() {
        Minecraft.getInstance().player.swing(InteractionHand.MAIN_HAND);
    }

    private static int queryLight(int x, int y, int z) {
        ClientLevel level = Minecraft.getInstance().level;
        BlockPos pos = new BlockPos(x, y, z);
        int block = level.getBrightness(LightLayer.BLOCK, pos);
        int sky = level.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)block, (int)sky);
    }

    private static boolean queryLight(int[] data) {
        ClientLevel level = Minecraft.getInstance().level;
        int i = 0;
        while (i != data.length) {
            int sky;
            BlockPos pos;
            int block;
            if (LightTexture.pack((int)(block = level.getBrightness(LightLayer.BLOCK, pos = new BlockPos(data[i++], data[i++], data[i++]))), (int)(sky = level.getBrightness(LightLayer.SKY, pos))) == data[i++]) continue;
            return false;
        }
        return true;
    }

    private static int countStacks(Item item) {
        return CommonHandler.countStacks(CommonHandler.gatherStacks((Player)Minecraft.getInstance().player, item));
    }

    private static String dim() {
        return Minecraft.getInstance().level.dimension().location().toString();
    }

    private static void playClickSound() {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    private static double[] getOutlineBoxes(int x, int y, int z) {
        ClientLevel level = Minecraft.getInstance().level;
        BlockPos pos = new BlockPos(x, y, z);
        return CommonHandler.getOutlineBoxes(pos, level.getBlockState(pos), (Level)level);
    }

    private static double[] getExtOutlineBoxes(int x0, int y0, int z0) {
        ClientLevel level = Minecraft.getInstance().level;
        DoubleArrayList boxes = new DoubleArrayList();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    int x = x0 + i;
                    int y = y0 + j;
                    int z = z0 + k;
                    BlockPos pos = new BlockPos(x, y, z);
                    level.getBlockState(pos).getShape((BlockGetter)level, pos).forAllBoxes((xn, yn, zn, xp, yp, zp) -> {
                        boxes.add(xn + (double)x);
                        boxes.add(yn + (double)y);
                        boxes.add(zn + (double)z);
                        boxes.add(xp + (double)x);
                        boxes.add(yp + (double)y);
                        boxes.add(zp + (double)z);
                    });
                }
            }
        }
        return boxes.toDoubleArray();
    }

    private static void batchText(GuiGraphics gui, FormattedCharSequence text, float x, float y, int color, boolean shadow) {
        Minecraft.getInstance().font.drawInBatch(text, x, y, color, shadow, gui.pose().last().pose(), (MultiBufferSource)gui.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public static void renderLevel(RenderLevelStageEvent evt) {
        RenderLevelStageEvent.Stage stage = evt.getStage();
        if (stage.equals(RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS)) {
            Minecraft mc = Minecraft.getInstance();
            Window fb = mc.getWindow();
            ItemStack mainHand = ItemStack.EMPTY;
            ItemStack offHand = ItemStack.EMPTY;
            if (mc.player != null) {
                mainHand = mc.player.getMainHandItem();
                offHand = mc.player.getOffhandItem();
            }
            evt.getProjectionMatrix().get(0, TRANSFORMS);
            evt.getModelViewMatrix().get(16, TRANSFORMS);
            if (mc.level.effects().constantAmbientLight()) {
                Lighting.setupNetherLevel();
            } else {
                Lighting.setupLevel();
            }
            boolean shadow = false;
            if (TRY_IRIS) {
                try {
                    shadow = ShadowRenderer.ACTIVE;
                }
                catch (NoClassDefFoundError ignored) {
                    TRY_IRIS = false;
                }
            }
            Vec3 eye = evt.getCamera().getPosition();
            ClientHandler.renderLevel(eye.x, eye.y, eye.z, shadow, mc.options.keySprint.isDown(), fb.getScreenWidth(), fb.getScreenHeight(), fb.getWidth(), fb.getHeight(), fb.getGuiScale(), evt.getPartialTick().getGameTimeDeltaPartialTick(true), CommonHandler.itemId(mainHand), CommonHandler.itemId(offHand));
        } else if (stage.equals(RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS)) {
            ClientHandler.renderTranslucent();
        }
    }

    public static void renderGui(RenderGuiEvent.Pre evt) {
        ClientHandler.renderGui(evt.getGuiGraphics());
    }

    public static void onStitch(TextureAtlasStitchedEvent evt) {
        TextureAtlas atlas = evt.getAtlas();
        if (atlas.location().equals((Object)TextureAtlas.LOCATION_BLOCKS)) {
            ClientHandler.loadSprites(atlas);
        }
    }

    public static void onTick(ClientTickEvent.Pre ignored) {
        ClientHandler.tick();
    }

    public static void onInteract(InputEvent.InteractionKeyMappingTriggered evt) {
        if (!evt.isUseItem()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.hitResult != null && ClientHandler.interact(mc.hitResult, mc.options.keyShift.isDown())) {
            evt.setSwingHand(true);
            evt.setCanceled(true);
        }
    }
}

