/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.client;

import com.mojang.blaze3d.vertex.PoseStack;
import cyb0124.curvy_pipes.client.ClientHandler;
import cyb0124.curvy_pipes.common.BuiltInPipeItem;
import cyb0124.curvy_pipes.compat.AEIconItem;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;

public class ItemRenderer
extends BlockEntityWithoutLevelRenderer
implements IClientItemExtensions {
    public static final ItemRenderer INST = new ItemRenderer();

    private ItemRenderer() {
        super(null, null);
    }

    public BlockEntityWithoutLevelRenderer getCustomRenderer() {
        return this;
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext ctx, PoseStack pPose, MultiBufferSource src, int light, int overlay) {
        PoseStack.Pose pose = pPose.last();
        pose.pose().get(0, ClientHandler.TRANSFORMS);
        pose.normal().get(16, ClientHandler.TRANSFORMS);
        Item item = stack.getItem();
        if (item instanceof BuiltInPipeItem) {
            ClientHandler.renderPipeItem(Item.getId((Item)item), light, overlay, ctx == ItemDisplayContext.GUI ? 2 : 0);
        } else if (item instanceof AEIconItem) {
            CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            if (data == null) {
                return;
            }
            CompoundTag tag = data.getUnsafe();
            ResourceLocation loc = ResourceLocation.tryParse((String)tag.getString("pipe"));
            if (loc == null) {
                return;
            }
            item = (Item)BuiltInRegistries.ITEM.get(loc);
            if (item == Items.AIR) {
                return;
            }
            ClientHandler.renderPipeItem(Item.getId((Item)item), light, overlay, tag.getBoolean("joint") ? 3 : 1);
        }
    }

    public static void onRegister(RegisterClientExtensionsEvent evt) {
        for (Item item : ClientHandler.customRenderItems()) {
            evt.registerItem((IClientItemExtensions)INST, new Item[]{item});
        }
        if (AEIconItem.INST != null) {
            evt.registerItem((IClientItemExtensions)INST, new Item[]{AEIconItem.INST});
        }
    }
}

