/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.inv;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import cyb0124.curvy_pipes.common.CommonHandler;
import cyb0124.curvy_pipes.inv.Typical;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

abstract class ItemInv<T>
extends Typical<T> {
    private static boolean TRY_STORAGE_DRAWERS = true;
    protected ItemStack[] items;
    protected int[] slots;
    protected int[] hashes;

    protected ItemInv(T inner, boolean split) {
        super(inner, split);
    }

    private static ItemInv<?> resolve(ServerLevel level, int cx, int cz, int x, int y, int z, byte dir) {
        IItemHandler cap;
        LevelChunk chunk = level.getChunkSource().getChunkNow(cx, cz);
        if (chunk == null) {
            return null;
        }
        BlockPos pos = new BlockPos(x, y, z);
        if (TRY_STORAGE_DRAWERS) {
            try {
                BlockEntity blockEntity = chunk.getBlockEntity(pos);
                if (blockEntity instanceof IDrawerGroup) {
                    IDrawerGroup group = (IDrawerGroup)blockEntity;
                    return new StorageDrawers(group);
                }
            }
            catch (NoClassDefFoundError ignored) {
                TRY_STORAGE_DRAWERS = false;
            }
        }
        return (cap = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)Direction.from3DDataValue((int)dir))) == null ? null : new Cap(cap);
    }

    protected void read() {
        int nSlots = this.nSlots();
        this.slots = new int[nSlots * 2];
        Object2IntLinkedOpenHashMap itemMap = new Object2IntLinkedOpenHashMap();
        for (int i = 0; i != nSlots; ++i) {
            ItemStack stack = this.get(i);
            if (stack == null) continue;
            HashedStack hashed = new HashedStack(stack, CommonHandler.itemId(stack), CommonHandler.itemPatchHash(stack));
            int oldSize = itemMap.size();
            this.slots[i * 2] = itemMap.computeIfAbsent((Object)hashed, ignored -> oldSize);
            this.slots[i * 2 + 1] = stack.getCount();
        }
        int size = itemMap.size();
        this.items = new ItemStack[size];
        this.hashes = new int[size * 2];
        int i = 0;
        for (HashedStack hashed : itemMap.keySet()) {
            this.items[i] = hashed.stack.copyWithCount(1);
            this.hashes[i * 2] = hashed.id;
            this.hashes[i * 2 + 1] = hashed.patchHash;
            ++i;
        }
    }

    protected abstract int nSlots();

    protected abstract ItemStack get(int var1);

    protected abstract int simExtract(int var1, ItemStack var2, int var3);

    protected abstract void execExtract(int var1, int var2);

    protected abstract int insert(int var1, ItemStack var2, int var3, boolean var4);

    private static class StorageDrawers
    extends ItemInv<IDrawerGroup> {
        private int[] slotMap;

        protected StorageDrawers(IDrawerGroup inner) {
            super(inner, false);
        }

        @Override
        protected void read() {
            this.slotMap = ((IDrawerGroup)this.inner).getAccessibleDrawerSlots();
            super.read();
        }

        @Override
        protected int nSlots() {
            return this.slotMap.length;
        }

        @Override
        protected ItemStack get(int slot) {
            IDrawer drawer = ((IDrawerGroup)this.inner).getDrawer(this.slotMap[slot]);
            int qty = drawer.getStoredItemCount();
            return qty > 0 ? drawer.getStoredItemPrototype().copyWithCount(qty) : null;
        }

        @Override
        protected int simExtract(int slot, ItemStack item, int qty) {
            IDrawer drawer = ((IDrawerGroup)this.inner).getDrawer(this.slotMap[slot]);
            return !drawer.getAttributes().isSuspended() && drawer.canItemBeExtracted(item) ? drawer.getStoredItemCount() : 0;
        }

        @Override
        protected void execExtract(int slot, int qty) {
            ((IDrawerGroup)this.inner).getDrawer(this.slotMap[slot]).adjustStoredItemCount(-qty);
        }

        @Override
        protected int insert(int slot, ItemStack item, int qty, boolean sim) {
            IDrawer drawer = ((IDrawerGroup)this.inner).getDrawer(this.slotMap[slot]);
            if (drawer.getAttributes().isSuspended() || !drawer.canItemBeStored(item)) {
                return qty;
            }
            boolean empty = drawer.isEmpty();
            if (sim) {
                return qty - (empty ? drawer.getAcceptingMaxCapacity(item) : drawer.getAcceptingRemainingCapacity());
            }
            if (empty) {
                drawer = drawer.setStoredItem(item);
            }
            return drawer.adjustStoredItemCount(qty);
        }
    }

    private static class Cap
    extends ItemInv<IItemHandler> {
        private Cap(IItemHandler inner) {
            super(inner, true);
        }

        @Override
        protected int nSlots() {
            return ((IItemHandler)this.inner).getSlots();
        }

        @Override
        protected ItemStack get(int slot) {
            ItemStack out = ((IItemHandler)this.inner).getStackInSlot(slot);
            return out.isEmpty() ? null : out;
        }

        @Override
        protected int simExtract(int slot, ItemStack item, int qty) {
            ItemStack out = ((IItemHandler)this.inner).extractItem(slot, qty, true);
            return ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)out) ? out.getCount() : 0;
        }

        @Override
        protected void execExtract(int slot, int qty) {
            ((IItemHandler)this.inner).extractItem(slot, qty, false);
        }

        @Override
        protected int insert(int slot, ItemStack item, int qty, boolean sim) {
            return ((IItemHandler)this.inner).insertItem(slot, item.copyWithCount(qty), sim).getCount();
        }
    }

    private record HashedStack(ItemStack stack, int id, int patchHash) {
        @Override
        public int hashCode() {
            return 31 * (31 + this.id) + this.patchHash;
        }

        @Override
        public boolean equals(Object o) {
            return ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)((HashedStack)o).stack);
        }
    }
}

