/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.inv;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import cyb0124.curvy_pipes.common.CommonHandler;
import cyb0124.curvy_pipes.inv.Typical;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

abstract class ItemInv<T>
extends Typical<T> {
    private static boolean TRY_STORAGE_DRAWERS = true;
    protected ItemStack[] items;
    protected int[] slots;
    protected int[] hashes;

    protected ItemInv(T inner, boolean split) {
        super(inner, split);
    }

    private static ItemInv<?> resolve(ServerLevel level, int cx, int cz, int x, int y, int z, byte dir) {
        LevelChunk chunk = level.m_7726_().m_7131_(cx, cz);
        if (chunk == null) {
            return null;
        }
        BlockPos pos = new BlockPos(x, y, z);
        BlockEntity tile = chunk.m_7702_(pos);
        if (tile == null) {
            BlockState state = chunk.m_8055_(pos);
            Block block = state.m_60734_();
            if (block instanceof WorldlyContainerHolder) {
                WorldlyContainerHolder block2 = (WorldlyContainerHolder)block;
                return new Container(block2.m_5840_(state, (LevelAccessor)level, pos), Direction.m_122376_((int)dir));
            }
            return null;
        }
        if (TRY_STORAGE_DRAWERS) {
            try {
                if (tile instanceof IDrawerGroup) {
                    IDrawerGroup group = (IDrawerGroup)tile;
                    return new StorageDrawers(group);
                }
            }
            catch (NoClassDefFoundError ignored) {
                TRY_STORAGE_DRAWERS = false;
            }
        }
        return tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.m_122376_((int)dir)).map(Cap::new).orElse(null);
    }

    protected void read() {
        int nSlots = this.nSlots();
        this.slots = new int[nSlots * 2];
        Object2IntLinkedOpenHashMap itemMap = new Object2IntLinkedOpenHashMap();
        for (int i = 0; i != nSlots; ++i) {
            ItemStack stack = this.get(i);
            if (stack == null) continue;
            HashedStack hashed = new HashedStack(stack, CommonHandler.itemId(stack), CommonHandler.itemTagHash(stack));
            int oldSize = itemMap.size();
            this.slots[i * 2] = itemMap.computeIfAbsent((Object)hashed, ignored -> oldSize);
            this.slots[i * 2 + 1] = stack.m_41613_();
        }
        int size = itemMap.size();
        this.items = new ItemStack[size];
        this.hashes = new int[size * 2];
        int i = 0;
        for (HashedStack hashed : itemMap.keySet()) {
            this.items[i] = CommonHandler.copyItemWithQty(hashed.stack, 1);
            this.hashes[i * 2] = hashed.id;
            this.hashes[i * 2 + 1] = hashed.tagHash;
            ++i;
        }
    }

    protected abstract int nSlots();

    protected abstract ItemStack get(int var1);

    protected abstract int simExtract(int var1, ItemStack var2, int var3);

    protected abstract void execExtract(int var1, int var2);

    protected abstract int insert(int var1, ItemStack var2, int var3, boolean var4);

    private static class Container
    extends ItemInv<Void> {
        private final WorldlyContainer inner;
        private final Direction dir;
        private final int[] slotMap;

        private Container(WorldlyContainer inner, Direction dir) {
            super(null, true);
            this.inner = inner;
            this.dir = dir;
            this.slotMap = inner.m_7071_(dir);
        }

        @Override
        protected int nSlots() {
            return this.slotMap.length;
        }

        @Override
        protected ItemStack get(int slot) {
            ItemStack out = this.inner.m_8020_(this.slotMap[slot]);
            return out.m_41619_() ? null : out;
        }

        @Override
        protected int simExtract(int slot, ItemStack item, int qty) {
            ItemStack out = this.inner.m_8020_(slot = this.slotMap[slot]);
            return ItemStack.m_150942_((ItemStack)out, (ItemStack)item) && this.inner.m_7157_(slot, item, this.dir) ? out.m_41613_() : 0;
        }

        @Override
        protected void execExtract(int slot, int qty) {
            this.inner.m_7407_(this.slotMap[slot], qty);
        }

        @Override
        protected int insert(int slot, ItemStack item, int qty, boolean sim) {
            if (!this.inner.m_7155_(slot = this.slotMap[slot], item, this.dir)) {
                return qty;
            }
            ItemStack dst = this.inner.m_8020_(slot);
            if (!dst.m_41619_() && !ItemStack.m_150942_((ItemStack)item, (ItemStack)dst)) {
                return qty;
            }
            int base = dst.m_41613_();
            int used = Math.min(qty, Math.min(item.m_41741_(), this.inner.m_6893_()) - base);
            if (used <= 0) {
                return qty;
            }
            if (!sim) {
                this.inner.m_6836_(slot, CommonHandler.copyItemWithQty(item, base + used));
            }
            return qty - used;
        }
    }

    private static class StorageDrawers
    extends ItemInv<IDrawerGroup> {
        private int[] slotMap;

        protected StorageDrawers(IDrawerGroup inner) {
            super(inner, false);
        }

        @Override
        protected void read() {
            this.slotMap = ((IDrawerGroup)this.inner).getAccessibleDrawerSlots();
            super.read();
        }

        @Override
        protected int nSlots() {
            return this.slotMap.length;
        }

        @Override
        protected ItemStack get(int slot) {
            IDrawer drawer = ((IDrawerGroup)this.inner).getDrawer(this.slotMap[slot]);
            int qty = drawer.getStoredItemCount();
            return qty > 0 ? CommonHandler.copyItemWithQty(drawer.getStoredItemPrototype(), qty) : null;
        }

        @Override
        protected int simExtract(int slot, ItemStack item, int qty) {
            IDrawer drawer = ((IDrawerGroup)this.inner).getDrawer(this.slotMap[slot]);
            return drawer.canItemBeExtracted(item) ? drawer.getStoredItemCount() : 0;
        }

        @Override
        protected void execExtract(int slot, int qty) {
            ((IDrawerGroup)this.inner).getDrawer(this.slotMap[slot]).adjustStoredItemCount(-qty);
        }

        @Override
        protected int insert(int slot, ItemStack item, int qty, boolean sim) {
            IDrawer drawer = ((IDrawerGroup)this.inner).getDrawer(this.slotMap[slot]);
            if (!drawer.canItemBeStored(item)) {
                return qty;
            }
            boolean empty = drawer.isEmpty();
            if (sim) {
                return qty - (empty ? drawer.getAcceptingMaxCapacity(item) : drawer.getAcceptingRemainingCapacity());
            }
            if (empty) {
                drawer = drawer.setStoredItem(item);
            }
            return drawer.adjustStoredItemCount(qty);
        }
    }

    private record HashedStack(ItemStack stack, int id, int tagHash) {
        @Override
        public int hashCode() {
            return 31 * (31 + this.id) + this.tagHash;
        }

        @Override
        public boolean equals(Object o) {
            return ItemStack.m_150942_((ItemStack)this.stack, (ItemStack)((HashedStack)o).stack);
        }
    }

    private static class Cap
    extends ItemInv<IItemHandler> {
        private Cap(IItemHandler inner) {
            super(inner, true);
        }

        @Override
        protected int nSlots() {
            return ((IItemHandler)this.inner).getSlots();
        }

        @Override
        protected ItemStack get(int slot) {
            ItemStack out = ((IItemHandler)this.inner).getStackInSlot(slot);
            return out.m_41619_() ? null : out;
        }

        @Override
        protected int simExtract(int slot, ItemStack item, int qty) {
            ItemStack out = ((IItemHandler)this.inner).extractItem(slot, qty, true);
            return ItemStack.m_150942_((ItemStack)item, (ItemStack)out) ? out.m_41613_() : 0;
        }

        @Override
        protected void execExtract(int slot, int qty) {
            ((IItemHandler)this.inner).extractItem(slot, qty, false);
        }

        @Override
        protected int insert(int slot, ItemStack item, int qty, boolean sim) {
            return ((IItemHandler)this.inner).insertItem(slot, CommonHandler.copyItemWithQty(item, qty), sim).m_41613_();
        }
    }
}

