/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLModIdMappingEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.EventBus;
import cyb0124.NativeLoader;
import cyb0124.curvy_pipes.client.ClientHandler;
import cyb0124.curvy_pipes.common.CommonHandler;
import cyb0124.curvy_pipes.common.NetHandler;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@cpw.mods.fml.common.Mod(modid="curvy_pipes", name="Curvy Pipes", version="1.4.2")
public class Mod {
    public static final String NAMESPACE = "curvy_pipes";
    public static final boolean IS_CLIENT = FMLCommonHandler.instance().getSide().isClient();
    public static final Logger LOGGER = LogManager.getLogger((String)"curvy_pipes");
    private static final NetHandler NET = new NetHandler();

    public Mod() throws Exception {
        this.loadNatives();
        CommonHandler.loadConfig();
        EventBus fmlBus = FMLCommonHandler.instance().bus();
        CommonHandler common = new CommonHandler();
        fmlBus.register((Object)common);
        MinecraftForge.EVENT_BUS.register((Object)common);
        if (IS_CLIENT) {
            ClientHandler client = new ClientHandler();
            fmlBus.register((Object)client);
            MinecraftForge.EVENT_BUS.register((Object)client);
        }
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent evt) {
        CommonHandler.onRegister();
        if (IS_CLIENT) {
            ClientHandler.onRegister();
        }
    }

    @Mod.EventHandler
    public void onIdMap(FMLModIdMappingEvent evt) {
        CommonHandler.idMapped();
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent evt) {
        CommonHandler.idMapped();
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent evt) {
        CommonHandler.applyRecipes();
    }

    private void loadNatives() throws Exception {
        byte[] blob;
        String path = "/" + NativeLoader.ARCH + ".bin";
        try (InputStream is = Mod.class.getResourceAsStream(path);){
            blob = IOUtils.toByteArray((InputStream)is);
        }
        ByteBuffer srcBuf = ByteBuffer.wrap(blob, blob.length - 4, 4);
        int len = srcBuf.getInt();
        long mem = NativeLoader.allocPagesRW(len);
        ByteBuffer dstBuf = NativeLoader.wrapBuffer(mem, len);
        dstBuf.order(ByteOrder.LITTLE_ENDIAN);
        dstBuf.put(blob, 0, len);
        srcBuf.position(len);
        while (srcBuf.remaining() > 16) {
            dstBuf.position(srcBuf.getInt());
            dstBuf.putLong(mem + (long)srcBuf.getInt());
        }
        long rxSize = (long)srcBuf.getInt() * 4096L;
        long table = mem + (long)srcBuf.getInt();
        long entry = NativeLoader.IS_WINDOWS ? mem + (long)srcBuf.getInt() : mem;
        NativeLoader.setAndRunPagesRX(mem, rxSize, table, entry, this);
    }
}

