/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.common;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameData;
import cyb0124.curvy_pipes.Mod;
import cyb0124.curvy_pipes.common.BuiltInPipeItem;
import cyb0124.curvy_pipes.common.SaveData;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.io.IOUtils;

public class CommonHandler {
    private static native void loadConfig(String var0);

    private static native short[] creativeTabData();

    public static native void idMapped();

    private static native void loadWorld(WorldServer var0, int var1, byte[] var2, WorldSavedData var3);

    private static native void unloadWorld(WorldServer var0);

    static native byte[] saveWorld(WorldServer var0);

    private static native void chunkLoaded(WorldServer var0, int var1, int var2);

    private static native void chunkUnloaded(WorldServer var0, int var1, int var2);

    private static native void watchChunk(EntityPlayerMP var0, int var1, int var2);

    private static native void unwatchChunk(EntityPlayerMP var0, int var1, int var2);

    private static native void tick();

    public static native void applyRecipes();

    public static native boolean useItem(ItemStack var0, EntityPlayer var1, World var2, boolean var3);

    private static void queueWorker(Runnable task) {
        ForkJoinPool.commonPool().execute(task);
    }

    private static double[] getServerBlockBoxes(WorldServer world, int cx, int cz, int x, int y, int z) {
        if (y < 0 || y >= 256) {
            return new double[0];
        }
        Chunk chunk = (Chunk)world.field_73059_b.field_73244_f.func_76164_a(ChunkCoordIntPair.func_77272_a((int)cx, (int)cz));
        if (chunk == null) {
            return new double[0];
        }
        Block block = chunk.func_150810_a(x & 0xF, y, z & 0xF);
        block.func_149719_a((IBlockAccess)world, x, y, z);
        ArrayList boxes = new ArrayList();
        block.func_149743_a((World)world, x, y, z, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)), boxes, null);
        double[] out = new double[boxes.size() * 6];
        int i = 0;
        for (AxisAlignedBB box : boxes) {
            out[i++] = box.field_72340_a;
            out[i++] = box.field_72338_b;
            out[i++] = box.field_72339_c;
            out[i++] = box.field_72336_d;
            out[i++] = box.field_72337_e;
            out[i++] = box.field_72334_f;
        }
        return out;
    }

    private static double playerReach(EntityPlayerMP player) {
        return player.field_71134_c.getBlockReachDistance();
    }

    public static boolean checkCreative(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d;
    }

    private static GatheredStacks gatherStacks(EntityPlayer player, Item pItem, short meta) {
        ItemStack item = new ItemStack(pItem, 1, (int)meta);
        GatheredStacks result = new GatheredStacks();
        result.player = player;
        GatheredStacks.access$202(result, new int[player.field_71071_by.field_70462_a.length]);
        int selected = player.field_71071_by.field_70461_c;
        if (selected < 0 || selected >= 9) {
            selected = -1;
        }
        ItemStack[] inv = player.field_71071_by.field_70462_a;
        if (selected >= 0 && inv[selected] != null && item.func_77969_a(inv[selected])) {
            ((GatheredStacks)result).slots[((GatheredStacks)result).numSlots++] = selected;
        }
        for (int i = 0; i != inv.length; ++i) {
            if (i == selected || inv[i] == null || !item.func_77969_a(inv[i])) continue;
            ((GatheredStacks)result).slots[((GatheredStacks)result).numSlots++] = i;
        }
        return result;
    }

    private static int countStacks(GatheredStacks stacks) {
        ItemStack[] inv = ((GatheredStacks)stacks).player.field_71071_by.field_70462_a;
        int sum = 0;
        for (int i = 0; i != stacks.numSlots; ++i) {
            sum += inv[((GatheredStacks)stacks).slots[i]].field_77994_a;
        }
        return sum;
    }

    private static void consumeStacks(GatheredStacks stacks, int count) {
        ItemStack[] inv = ((GatheredStacks)stacks).player.field_71071_by.field_70462_a;
        while (count != 0) {
            int slot = stacks.slots[--stacks.numSlots];
            ItemStack stack = inv[slot];
            int avail = Math.min(stack.field_77994_a, count);
            stack.field_77994_a -= avail;
            if (stack.field_77994_a == 0) {
                inv[slot] = null;
            }
            count -= avail;
        }
        ((GatheredStacks)stacks).player.field_71069_bz.func_75142_b();
    }

    private static void spawnStack(WorldServer world, Item item, short meta, int qty, double x, double y, double z) {
        world.func_72838_d((Entity)new EntityItem((World)world, x, y, z, new ItemStack(item, qty, (int)meta)));
    }

    private static ItemStack copyItemWithQty(ItemStack stack, int qty) {
        stack = stack.func_77946_l();
        stack.field_77994_a = qty;
        return stack;
    }

    private static int itemId(ItemStack stack) {
        return Item.func_150891_b((Item)stack.func_77973_b());
    }

    private static boolean isSameItemAndTag(ItemStack x, ItemStack y) {
        return x.func_77969_a(y) && ItemStack.func_77970_a((ItemStack)x, (ItemStack)y);
    }

    private static int itemTagHash(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().hashCode() : 0;
    }

    private static long fluidAndTagCatenatedHash(FluidStack stack) {
        long result = stack.getFluid().hashCode();
        return stack.tag == null ? result : result << 32 | (long)stack.tag.hashCode();
    }

    public static FluidStack copyFluidWithQty(FluidStack stack, int qty) {
        stack = stack.copy();
        stack.amount = qty;
        return stack;
    }

    private static byte[] encodeItem(ItemStack stack) throws IOException {
        ByteArrayDataOutput data = ByteStreams.newDataOutput();
        CompressedStreamTools.func_74800_a((NBTTagCompound)stack.func_77955_b(new NBTTagCompound()), (DataOutput)data);
        return data.toByteArray();
    }

    private static ItemStack decodeItem(byte[] data) throws IOException {
        return ItemStack.func_77949_a((NBTTagCompound)CompressedStreamTools.func_152456_a((DataInput)ByteStreams.newDataInput((byte[])data), (NBTSizeTracker)NBTSizeTracker.field_152451_a));
    }

    private static byte[] encodeFluid(FluidStack stack) throws IOException {
        NBTTagCompound tag = new NBTTagCompound();
        stack.writeToNBT(tag);
        ByteArrayDataOutput data = ByteStreams.newDataOutput();
        CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)data);
        return data.toByteArray();
    }

    private static FluidStack decodeFluid(byte[] data) throws IOException {
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)CompressedStreamTools.func_152456_a((DataInput)ByteStreams.newDataInput((byte[])data), (NBTSizeTracker)NBTSizeTracker.field_152451_a));
    }

    private static FluidStack fluidOfItem(ItemStack stack) {
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
        return fluid != null && fluid.amount > 0 ? fluid : null;
    }

    public static TileEntity getTile(WorldServer world, int cx, int cz, int x, int y, int z) {
        if (y < 0 || y >= 256) {
            return null;
        }
        Chunk chunk = (Chunk)world.field_73059_b.field_73244_f.func_76164_a(ChunkCoordIntPair.func_77272_a((int)cx, (int)cz));
        if (chunk == null) {
            return null;
        }
        return chunk.getTileEntityUnsafe(x & 0xF, y, z & 0xF);
    }

    private static IInventory tryCombineChests(TileEntityChest x, TileEntityChest y) {
        return x.func_145980_j() == y.func_145980_j() ? new InventoryLargeChest("", (IInventory)x, (IInventory)y) : null;
    }

    private static InvData readInv(IInventory inv, int[] slotMap) {
        InvData result = new InvData();
        int nSlots = slotMap == null ? inv.func_70302_i_() : slotMap.length;
        InvData.access$602(result, new int[nSlots * 2]);
        LinkedHashMap<HashedStack, Integer> itemMap = new LinkedHashMap<HashedStack, Integer>();
        for (int i = 0; i != nSlots; ++i) {
            ItemStack stack = inv.func_70301_a(slotMap == null ? i : slotMap[i]);
            if (stack == null || stack.field_77994_a <= 0) continue;
            HashedStack hashed = new HashedStack(stack, CommonHandler.itemId(stack), stack.func_77960_j(), CommonHandler.itemTagHash(stack));
            int oldSize = itemMap.size();
            ((InvData)result).slots[i * 2] = itemMap.computeIfAbsent(hashed, ignored -> oldSize);
            ((InvData)result).slots[i * 2 + 1] = stack.field_77994_a;
        }
        int size = itemMap.size();
        InvData.access$802(result, new ItemStack[size]);
        InvData.access$902(result, new int[size * 3]);
        int i = 0;
        for (HashedStack hashed : itemMap.keySet()) {
            ((InvData)result).stacks[i] = CommonHandler.copyItemWithQty(hashed.stack, 1);
            ((InvData)result).hashes[i * 3] = hashed.id;
            ((InvData)result).hashes[i * 3 + 1] = hashed.meta;
            ((InvData)result).hashes[i * 3 + 2] = hashed.tagHash;
            ++i;
        }
        return result;
    }

    private static ItemStack extractItem(IInventory inv, int slot, int qty, byte dir, boolean sim) {
        ItemStack stack = inv.func_70301_a(slot);
        if (stack == null || stack.field_77994_a <= 0 || dir >= 0 && !((ISidedInventory)inv).func_102008_b(slot, stack, (int)dir)) {
            return null;
        }
        qty = Math.min(stack.field_77994_a, qty);
        if (sim) {
            return CommonHandler.copyItemWithQty(stack, qty);
        }
        return inv.func_70298_a(slot, qty);
    }

    private static int insertItem(IInventory inv, ItemStack stack, int slot, int reqQty, byte dir, boolean sim) {
        int procQty;
        stack = CommonHandler.copyItemWithQty(stack, reqQty);
        if (!(dir >= 0 ? ((ISidedInventory)inv).func_102007_a(slot, stack, (int)dir) : inv.func_94041_b(slot, stack))) {
            return reqQty;
        }
        ItemStack existing = inv.func_70301_a(slot);
        int existingQty = 0;
        if (existing != null) {
            if (!CommonHandler.isSameItemAndTag(stack, existing)) {
                return reqQty;
            }
            existingQty = existing.field_77994_a;
        }
        if ((procQty = Math.min(Math.min(stack.func_77976_d(), inv.func_70297_j_()) - existingQty, reqQty)) <= 0) {
            return reqQty;
        }
        if (!sim) {
            stack.field_77994_a = existingQty + procQty;
            inv.func_70299_a(slot, stack);
        }
        return reqQty - procQty;
    }

    public static void onWorldLoad(WorldServer world) {
        SaveData data = (SaveData)world.perWorldStorage.func_75742_a(SaveData.class, "curvy_pipes");
        if (data == null) {
            data = new SaveData("curvy_pipes");
            world.perWorldStorage.func_75745_a("curvy_pipes", (WorldSavedData)data);
        }
        data.world = world;
        CommonHandler.loadWorld(world, world.field_73011_w.field_76574_g, data.toLoad, data);
        data.toLoad = null;
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load evt) {
        if (!(evt.world instanceof WorldServer)) {
            return;
        }
        CommonHandler.onWorldLoad((WorldServer)evt.world);
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load evt) {
        if (!(evt.world instanceof WorldServer)) {
            return;
        }
        Chunk chunk = evt.getChunk();
        CommonHandler.chunkLoaded((WorldServer)evt.world, chunk.field_76635_g, chunk.field_76647_h);
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload evt) {
        if (!(evt.world instanceof WorldServer)) {
            return;
        }
        Chunk chunk = evt.getChunk();
        CommonHandler.chunkUnloaded((WorldServer)evt.world, chunk.field_76635_g, chunk.field_76647_h);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload evt) {
        CommonHandler.unloadWorld(evt.world instanceof WorldServer ? (WorldServer)evt.world : null);
    }

    @SubscribeEvent
    public void onChunkWatch(ChunkWatchEvent.Watch evt) {
        CommonHandler.watchChunk(evt.player, evt.chunk.field_77276_a, evt.chunk.field_77275_b);
    }

    @SubscribeEvent
    public void onChunkUnwatch(ChunkWatchEvent.UnWatch evt) {
        CommonHandler.unwatchChunk(evt.player, evt.chunk.field_77276_a, evt.chunk.field_77275_b);
    }

    public static void loadConfig() {
        String config;
        String defaultConfig;
        Path configDir = Loader.instance().getConfigDir().toPath();
        Path defaultPath = configDir.resolve("curvy_pipes_default.yaml");
        Path path = configDir.resolve("curvy_pipes.yaml");
        try (InputStream is = Mod.class.getResourceAsStream("/default.yaml");){
            defaultConfig = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            Files.write(defaultPath, defaultConfig.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        try {
            config = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            config = defaultConfig;
        }
        CommonHandler.loadConfig(config);
    }

    public static void onRegister() {
        final short[] tabData = CommonHandler.creativeTabData();
        CreativeTabs tab = tabData == null ? null : new CreativeTabs("curvy_pipes"){

            public Item func_78016_d() {
                return BuiltInPipeItem.INST;
            }

            public int func_151243_f() {
                return tabData[0];
            }
        };
        new BuiltInPipeItem(tab, tabData);
    }

    private static ItemStack parseStack(String name, short meta, int qty) {
        Item item = (Item)GameData.getItemRegistry().func_82594_a(name);
        if (item == null) {
            throw new RuntimeException("Unknown item name: " + name);
        }
        return new ItemStack(item, qty, (int)meta);
    }

    private static void applyRecipe(ItemStack out, boolean shaped, Object[] args) {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        recipes.add(shaped ? new ShapedOreRecipe(out, args) : new ShapelessOreRecipe(out, args));
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END) {
            CommonHandler.tick();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onInteract(PlayerInteractEvent evt) {
        ItemStack stack = evt.entityPlayer.field_71071_by.func_70448_g();
        if (stack == null) {
            return;
        }
        if (evt.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            if (!CommonHandler.useItem(stack, evt.entityPlayer, evt.world, false)) {
                return;
            }
            throw new SkipOtherListeners();
        }
        if (evt.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR) {
            if (!CommonHandler.useItem(stack, evt.entityPlayer, evt.world, true)) {
                return;
            }
            evt.setCanceled(true);
            throw new SkipOtherListeners();
        }
    }

    public static class SkipOtherListeners
    extends RuntimeException {
    }

    private static class InvData {
        private int[] slots;
        private int[] hashes;
        private ItemStack[] stacks;

        private InvData() {
        }

        static /* synthetic */ int[] access$602(InvData x0, int[] x1) {
            x0.slots = x1;
            return x1;
        }

        static /* synthetic */ ItemStack[] access$802(InvData x0, ItemStack[] x1) {
            x0.stacks = x1;
            return x1;
        }

        static /* synthetic */ int[] access$902(InvData x0, int[] x1) {
            x0.hashes = x1;
            return x1;
        }
    }

    private static class HashedStack {
        private final ItemStack stack;
        private final int id;
        private final int meta;
        private final int tagHash;

        private HashedStack(ItemStack stack, int id, int meta, int tagHash) {
            this.stack = stack;
            this.id = id;
            this.meta = meta;
            this.tagHash = tagHash;
        }

        public int hashCode() {
            return 31 * (31 * (31 + this.id) + this.meta) + this.tagHash;
        }

        public boolean equals(Object o) {
            return CommonHandler.isSameItemAndTag(this.stack, ((HashedStack)o).stack);
        }
    }

    private static class GatheredStacks {
        private EntityPlayer player;
        private int[] slots;
        private int numSlots;

        private GatheredStacks() {
        }

        static /* synthetic */ int[] access$202(GatheredStacks x0, int[] x1) {
            x0.slots = x1;
            return x1;
        }
    }
}

