/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.compat;

import cofh.api.energy.IEnergyReceiver;
import cyb0124.curvy_pipes.common.CommonHandler;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.util.GTUtil;
import gregtech.api.util.GTUtility;
import ic2.api.energy.tile.IEnergySink;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class GTPlugin {
    private static native long acceptEnergy(WorldServer var0, int var1, int var2, int var3, byte var4, long var5, long var7);

    public static long acceptEnergy(ForgeDirection dir, IHasWorldObjectAndCoords from, long volts, long totalAmps, long usedAmps) {
        if (usedAmps >= totalAmps) {
            return usedAmps;
        }
        World world = from.getWorld();
        if (!(world instanceof WorldServer)) {
            return usedAmps;
        }
        return usedAmps + GTPlugin.acceptEnergy((WorldServer)world, from.getXCoord(), from.getYCoord(), from.getZCoord(), (byte)dir.ordinal(), volts, totalAmps - usedAmps);
    }

    private static EnergySink resolveEnergySink(WorldServer world, int cx, int cz, int x, int y, int z, byte rawDir) {
        TileEntity tile = CommonHandler.getTile(world, cx, cz, x, y, z);
        if (tile == null) {
            return null;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)rawDir);
        if (tile instanceof IEnergyConnected) {
            IEnergyConnected sink = (IEnergyConnected)tile;
            return (volts, amps) -> sink.injectEnergyUnits(dir, volts, amps);
        }
        if (tile instanceof IEnergySink) {
            IEnergySink sink = (IEnergySink)tile;
            if (!sink.acceptsEnergyFrom(null, dir)) {
                return null;
            }
            return (volts, amps) -> {
                long used;
                for (used = 0L; amps > used && sink.getDemandedEnergy() > 0.0 && sink.injectEnergy(dir, (double)volts, (double)volts) < (double)volts; ++used) {
                }
                return used;
            };
        }
        if (GregTechAPI.mOutputRF && tile instanceof IEnergyReceiver) {
            IEnergyReceiver sink = (IEnergyReceiver)tile;
            return (volts, amps) -> {
                int rf = GTUtility.safeInt((long)(volts * (long)GregTechAPI.mEUtoRF / 100L));
                if (sink.receiveEnergy(dir, rf, true) == rf) {
                    sink.receiveEnergy(dir, rf, false);
                    return 1L;
                }
                return 0L;
            };
        }
        return null;
    }

    private static boolean shouldBurn(FluidStack stack, int maxTemp, boolean allowGas) {
        Fluid fluid = stack.getFluid();
        return fluid.getTemperature(stack) > maxTemp || !allowGas && fluid.isGaseous(stack);
    }

    public static class PipeMeta {
        private final Item item;
        private final int meta;
        private final String key;
        private final float thickness;
        private final int rgb;
        private final String iconSet;

        public PipeMeta(MetaPipeEntity mte, Materials mat) {
            ItemStack stack = mte.getStackForm(1L);
            this.item = stack.func_77973_b();
            this.meta = stack.func_77960_j();
            this.key = mte.getMetaName();
            this.thickness = mte.getThickNess();
            if (mat == null) {
                this.rgb = 0xFFFFFF;
                this.iconSet = null;
            } else {
                this.rgb = GTUtil.getRGBInt((short[])mat.getRGBA());
                this.iconSet = mat.mIconSet.mSetName;
            }
        }
    }

    private static interface EnergySink {
        public long sink(long var1, long var3);
    }
}

