/*
 * Decompiled with CFR 0.152.
 */
package ua.myxazaur.lemonskin.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ua.myxazaur.lemonskin.LemonSkin;
import ua.myxazaur.lemonskin.ModConfig;
import ua.myxazaur.lemonskin.ModInfo;
import ua.myxazaur.lemonskin.helpers.AppleCoreHelper;
import ua.myxazaur.lemonskin.helpers.BetterWithModsHelper;
import ua.myxazaur.lemonskin.helpers.FoodHelper;
import ua.myxazaur.lemonskin.helpers.KeyHelper;

@SideOnly(value=Side.CLIENT)
public class TooltipOverlayHandler {
    private static final ResourceLocation MOD_ICONS = new ResourceLocation(ModInfo.MODID_LOWER, "textures/icons.png");
    private ItemStack stack;
    private static final int LEGACY_BOTTOM_OFFSET = 3;
    private static final int LEGACY_TOP_OFFSET = -3;
    private static final int LEGACY_RIGHT_OFFSET = 3;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new TooltipOverlayHandler());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemTooltip(ItemTooltipEvent event) {
        boolean shouldShow;
        if (!ModConfig.CLIENT.USE_MODERN_TOOLTIP) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack == null || stack.func_190926_b()) {
            return;
        }
        this.stack = stack;
        boolean bl = shouldShow = ModConfig.CLIENT.SHOW_FOOD_VALUES_IN_TOOLTIP && KeyHelper.isShiftKeyDown() || ModConfig.CLIENT.ALWAYS_SHOW_FOOD_VALUES_TOOLTIP;
        if (!shouldShow || !FoodHelper.isFood(stack)) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        FoodHelper.BasicFoodValues base = FoodHelper.getDefaultFoodValues(stack);
        FoodHelper.BasicFoodValues actual = FoodHelper.getModifiedFoodValues(stack, (EntityPlayer)player);
        if (LemonSkin.hasAppleCore) {
            base = AppleCoreHelper.getFoodValuesForDisplay(base, (EntityPlayer)player);
            actual = AppleCoreHelper.getFoodValuesForDisplay(actual, (EntityPlayer)player);
        }
        if ((base = BetterWithModsHelper.getFoodValuesForDisplay(base)).equals(actual = BetterWithModsHelper.getFoodValuesForDisplay(actual)) && base.hunger == 0) {
            return;
        }
        int biggestHunger = Math.max(base.hunger, actual.hunger);
        float biggestSatInc = Math.max(base.getSaturationIncrement(), actual.getSaturationIncrement());
        int hungerBars = (int)Math.ceil((float)Math.abs(biggestHunger) / 2.0f);
        int satBars = (int)Math.max(1.0, Math.ceil(Math.abs(biggestSatInc) / 2.0f));
        float scale = 2.2f;
        float hungerLen = hungerBars < 10 ? (float)hungerBars * scale : 2.0f;
        float satLen = satBars < 10 ? (float)satBars * scale * 0.8f : 2.0f;
        int spacesNeeded = (int)Math.ceil(Math.max(hungerLen, satLen));
        StringBuilder sb = new StringBuilder("\u00a0");
        for (int i = 0; i < spacesNeeded; ++i) {
            sb.append("\u00a0");
        }
        event.getToolTip().add(sb.toString());
        event.getToolTip().add(sb.toString());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderTooltip(RenderTooltipEvent.PostText event) {
        boolean shouldShow;
        ItemStack stack = event.getStack();
        if (stack == null || stack.func_190926_b()) {
            stack = this.stack;
        }
        boolean bl = shouldShow = ModConfig.CLIENT.SHOW_FOOD_VALUES_IN_TOOLTIP && KeyHelper.isShiftKeyDown() || ModConfig.CLIENT.ALWAYS_SHOW_FOOD_VALUES_TOOLTIP;
        if (!shouldShow || !FoodHelper.isFood(stack)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        GuiScreen gui = mc.field_71462_r;
        if (gui == null) {
            return;
        }
        EntityPlayerSP player = mc.field_71439_g;
        FoodHelper.BasicFoodValues base = FoodHelper.getDefaultFoodValues(stack);
        FoodHelper.BasicFoodValues actual = FoodHelper.getModifiedFoodValues(stack, (EntityPlayer)player);
        if (LemonSkin.hasAppleCore) {
            base = AppleCoreHelper.getFoodValuesForDisplay(base, (EntityPlayer)player);
            actual = AppleCoreHelper.getFoodValuesForDisplay(actual, (EntityPlayer)player);
        }
        if ((base = BetterWithModsHelper.getFoodValuesForDisplay(base)).equals(actual = BetterWithModsHelper.getFoodValuesForDisplay(actual)) && base.hunger == 0) {
            return;
        }
        if (ModConfig.CLIENT.USE_MODERN_TOOLTIP) {
            this.renderModern(event, stack, base, actual);
        } else {
            this.renderLegacy(event, stack, base, actual);
        }
        this.stack = ItemStack.field_190927_a;
    }

    private void renderModern(RenderTooltipEvent.PostText event, ItemStack stack, FoodHelper.BasicFoodValues base, FoodHelper.BasicFoodValues actual) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiScreen gui = mc.field_71462_r;
        int biggestHunger = Math.max(base.hunger, actual.hunger);
        float biggestSatInc = Math.max(base.getSaturationIncrement(), actual.getSaturationIncrement());
        int hungerBars = (int)Math.ceil((float)Math.abs(biggestHunger) / 2.0f);
        int satBars = (int)Math.max(1.0, Math.ceil(Math.abs(biggestSatInc) / 2.0f));
        String hungerText = null;
        if (hungerBars > 10) {
            hungerText = "x" + (biggestHunger < 0 ? "-" : "") + hungerBars;
            hungerBars = 1;
        }
        String satText = null;
        if (satBars > 10 || satBars == 0) {
            satText = "x" + (biggestSatInc < 0.0f ? "-" : "") + satBars;
            satBars = 1;
        }
        int lineHeight = 10;
        int y = event.getY() + (event.getLines().size() - 2) * lineHeight + 2;
        int x = event.getX();
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        boolean rotten = FoodHelper.isRotten(stack);
        int iconOffset = rotten ? 36 : 0;
        int startX = x;
        for (int i = 0; i < hungerBars * 2; i += 2) {
            int u = actual.hunger < 0 ? 34 + iconOffset : (actual.hunger > base.hunger && base.hunger <= i ? 133 + iconOffset : (actual.hunger > i + 1 || base.hunger == actual.hunger ? 16 + (rotten ? 13 : 0) * 9 : (actual.hunger == i + 1 ? 124 : 34)));
            gui.func_73729_b(startX + i / 2 * 9, y, u, 27, 9, 9);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
            gui.func_73729_b(startX + i / 2 * 9, y, base.hunger - 1 == i ? 115 : 106, 27, 9, 9);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (actual.hunger <= i) continue;
            gui.func_73729_b(startX + i / 2 * 9, y, actual.hunger - 1 == i ? 61 + iconOffset : 52 + iconOffset, 27, 9, 9);
        }
        if (hungerText != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
            mc.field_71466_p.func_175063_a(hungerText, (float)((startX + hungerBars * 9 + 2) * 4 / 3), (float)(y * 4 / 3 + 2), -2236963);
            GlStateManager.func_179121_F();
        }
        y += 10;
        startX = x;
        float satInc = actual.getSaturationIncrement();
        float absSat = Math.abs(satInc);
        mc.func_110434_K().func_110577_a(MOD_ICONS);
        for (int i = 0; i < satBars * 2; i += 2) {
            int v;
            float eff = (absSat - (float)i) / 2.0f;
            int u = eff >= 1.0f ? 21 : ((double)eff > 0.5 ? 14 : ((double)eff > 0.25 ? 7 : (eff > 0.0f ? 0 : 28)));
            int n = v = satInc >= 0.0f ? 27 : 34;
            if (absSat <= (float)i) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            }
            gui.func_73729_b(startX + i / 2 * 7, y, u, v, 7, 7);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (satText != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
            mc.field_71466_p.func_175063_a(satText, (float)((startX + satBars * 6 + 2) * 4 / 3), (float)(y * 4 / 3 + 1), -2236963);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
    }

    private void renderLegacy(RenderTooltipEvent.PostText event, ItemStack stack, FoodHelper.BasicFoodValues base, FoodHelper.BasicFoodValues actual) {
        int satStartX;
        int hungerStartX;
        int maxRightX;
        int toolTipBottomY;
        String satText;
        int satBars;
        boolean satOverflow;
        String hungerText;
        boolean hungerOverflow;
        Minecraft mc = Minecraft.func_71410_x();
        GuiScreen gui = mc.field_71462_r;
        ScaledResolution scale = new ScaledResolution(mc);
        int toolTipY = event.getY();
        int toolTipX = event.getX();
        int toolTipW = event.getWidth();
        int toolTipH = event.getHeight();
        int biggestHunger = Math.max(base.hunger, actual.hunger);
        float biggestSatInc = Math.max(base.getSaturationIncrement(), actual.getSaturationIncrement());
        int hungerBars = (int)Math.ceil((float)Math.abs(biggestHunger) / 2.0f);
        boolean bl = hungerOverflow = hungerBars > 10;
        String string = hungerOverflow ? (biggestHunger < 0 ? -1 : 1) * hungerBars + "x" : (hungerText = null);
        if (hungerOverflow) {
            hungerBars = 1;
        }
        boolean bl2 = satOverflow = (satBars = (int)Math.max(1.0, Math.ceil(Math.abs(biggestSatInc) / 2.0f))) > 10;
        String string2 = satOverflow ? (biggestSatInc < 0.0f ? -1 : 1) * satBars + "x" : (satText = null);
        if (satOverflow) {
            satBars = 1;
        }
        boolean drawBelow = (toolTipBottomY = toolTipY + toolTipH + 1 + 3) + 20 < scale.func_78328_b() - 3;
        int topY = drawBelow ? toolTipBottomY : toolTipY - 20 + -3;
        int bottomY = topY + 19;
        int hungerIconsWidth = hungerBars * 9;
        int satIconsWidth = satBars * 6;
        int hungerTextWidth = hungerText == null ? 0 : (int)((float)mc.field_71466_p.func_78256_a(hungerText) * 0.75f);
        int satTextWidth = satText == null ? 0 : (int)((float)mc.field_71466_p.func_78256_a(satText) * 0.75f);
        int hungerLineWidth = hungerIconsWidth + (hungerTextWidth > 0 ? hungerTextWidth + 2 : 0);
        int satLineWidth = satIconsWidth + (satTextWidth > 0 ? satTextWidth + 2 : 0);
        int contentWidth = Math.max(hungerLineWidth, satLineWidth);
        int overlayWidth = contentWidth + 6;
        int minLeftX = toolTipX;
        int rightX = maxRightX = toolTipX + toolTipW;
        int leftX = rightX - overlayWidth;
        boolean needsTopBorder = false;
        if (leftX < minLeftX) {
            leftX = minLeftX;
            rightX = leftX + overlayWidth;
            needsTopBorder = true;
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        Gui.func_73734_a((int)(leftX - 1), (int)topY, (int)(rightX + 1), (int)bottomY, (int)-267386864);
        Gui.func_73734_a((int)leftX, (int)(drawBelow ? bottomY : topY - 1), (int)rightX, (int)(drawBelow ? bottomY + 1 : topY), (int)-267386864);
        if (needsTopBorder || !drawBelow) {
            Gui.func_73734_a((int)leftX, (int)(drawBelow ? topY - 1 : bottomY), (int)rightX, (int)(drawBelow ? topY : bottomY + 1), (int)-267386864);
        }
        Gui.func_73734_a((int)leftX, (int)topY, (int)rightX, (int)bottomY, (int)0x66FFFFFF);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        int rightPadding = 3;
        int y = bottomY - 18;
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        boolean isRotten = FoodHelper.isRotten(stack);
        int iconOffset = isRotten ? 36 : 0;
        int background = isRotten ? 13 : 0;
        int hungerTextX = rightX - rightPadding - hungerIconsWidth - (hungerTextWidth > 0 ? 2 : 0) - hungerTextWidth;
        int hungerX = hungerStartX = rightX - rightPadding - hungerIconsWidth;
        for (int i = hungerBars * 2 - 2; i >= 0; i -= 2) {
            if (actual.hunger < 0) {
                gui.func_73729_b(hungerX, y, 34 + iconOffset, 27, 9, 9);
            } else if (actual.hunger > base.hunger && base.hunger <= i) {
                gui.func_73729_b(hungerX, y, 133 + iconOffset, 27, 9, 9);
            } else if (actual.hunger > i + 1 || base.hunger == actual.hunger) {
                gui.func_73729_b(hungerX, y, 16 + background * 9, 27, 9, 9);
            } else if (actual.hunger == i + 1) {
                gui.func_73729_b(hungerX, y, 124, 27, 9, 9);
            } else {
                gui.func_73729_b(hungerX, y, 34, 27, 9, 9);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
            gui.func_73729_b(hungerX, y, base.hunger - 1 == i ? 115 : 106, 27, 9, 9);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (actual.hunger > i) {
                gui.func_73729_b(hungerX, y, actual.hunger - 1 == i ? 61 + iconOffset : 52 + iconOffset, 27, 9, 9);
            }
            hungerX += 9;
        }
        if (hungerText != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
            mc.field_71466_p.func_175063_a(hungerText, (float)(hungerTextX * 4 / 3), (float)(y * 4 / 3 + 2), -2236963);
            GlStateManager.func_179121_F();
        }
        y += 10;
        int satTextX = rightX - rightPadding - satIconsWidth - (satTextWidth > 0 ? 2 : 0) - satTextWidth;
        int satX = satStartX = rightX - rightPadding - satIconsWidth;
        float satInc = actual.getSaturationIncrement();
        float absSat = Math.abs(satInc);
        mc.func_110434_K().func_110577_a(MOD_ICONS);
        for (int i = satBars * 2 - 2; i >= 0; i -= 2) {
            int v;
            float eff = (absSat - (float)i) / 2.0f;
            int u = eff >= 1.0f ? 21 : ((double)eff > 0.5 ? 14 : ((double)eff > 0.25 ? 7 : (eff > 0.0f ? 0 : 28)));
            int n = v = satInc >= 0.0f ? 27 : 34;
            if (absSat <= (float)i) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            }
            gui.func_73729_b(satX, y, u, v, 7, 7);
            if (absSat <= (float)i) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            satX += 6;
        }
        if (satText != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
            mc.field_71466_p.func_175063_a(satText, (float)(satTextX * 4 / 3), (float)(y * 4 / 3 + 1), -2236963);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
    }
}

