/*
 * Decompiled with CFR 0.152.
 */
package ua.myxazaur.lemonskin.helpers;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.FoodStats;
import net.minecraft.world.World;
import ua.myxazaur.lemonskin.helpers.FoodHelper;
import ua.myxazaur.lemonskin.helpers.HungerHelper;

public class HealthHelper {
    public static final float REGEN_EXHAUSTION_INCREMENT = 6.0f;
    public static final float MAX_EXHAUSTION = 4.0f;

    public static float getEstimatedHealthIncrement(EntityPlayer player, FoodHelper.BasicFoodValues foodValues, PotionEffect effect) {
        if (!player.func_70996_bM()) {
            return 0.0f;
        }
        FoodStats stats = player.func_71024_bL();
        World world = player.field_70170_p;
        int foodLevel = Math.min(stats.func_75116_a() + foodValues.hunger, 20);
        float healthIncrement = 0.0f;
        if (foodLevel >= 18 && world != null && world.func_82736_K().func_82766_b("naturalRegeneration")) {
            float saturationLevel = Math.min(stats.func_75115_e() + foodValues.getSaturationIncrement(), (float)foodLevel);
            float exhaustionLevel = HungerHelper.getExhaustion(player);
            healthIncrement = HealthHelper.getEstimatedHealthIncrement(foodLevel, saturationLevel, exhaustionLevel);
        }
        if (effect != null && effect.func_188419_a() == MobEffects.field_76428_l) {
            int amplifier = effect.func_76458_c();
            int duration = effect.func_76459_b();
            healthIncrement += (float)Math.floor(duration / Math.max(50 >> amplifier, 1));
        }
        return healthIncrement;
    }

    public static float getEstimatedHealthIncrement(int foodLevel, float saturationLevel, float exhaustionLevel) {
        float health = 0.0f;
        if (!Float.isFinite(exhaustionLevel) || !Float.isFinite(saturationLevel)) {
            return 0.0f;
        }
        while (foodLevel >= 18) {
            while (exhaustionLevel > 4.0f) {
                exhaustionLevel -= 4.0f;
                if (saturationLevel > 0.0f) {
                    saturationLevel = Math.max(saturationLevel - 1.0f, 0.0f);
                    continue;
                }
                --foodLevel;
            }
            if (foodLevel < 18) break;
            if (foodLevel >= 20 && Float.compare(saturationLevel, Float.MIN_NORMAL) > 0) {
                float limitedSaturationLevel = Math.min(saturationLevel, 6.0f);
                float exhaustionUntilAboveMax = Math.nextUp(4.0f) - exhaustionLevel;
                int numIterationsUntilAboveMax = Math.max(1, (int)Math.ceil(exhaustionUntilAboveMax / limitedSaturationLevel));
                health += limitedSaturationLevel / 6.0f * (float)numIterationsUntilAboveMax;
                exhaustionLevel += limitedSaturationLevel * (float)numIterationsUntilAboveMax;
                continue;
            }
            if (foodLevel < 18) continue;
            health += 1.0f;
            exhaustionLevel += 6.0f;
        }
        return health;
    }
}

