/*
 * Decompiled with CFR 0.152.
 */
package ua.myxazaur.lemonskin.client;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ua.myxazaur.lemonskin.LemonSkin;

@SideOnly(value=Side.CLIENT)
public class GrayIconsReloader
implements IResourceManagerReloadListener {
    public void func_110549_a(IResourceManager resourceManager) {
        this.generateGrayIcons(resourceManager);
    }

    private void generateGrayIcons(IResourceManager resourceManager) {
        try {
            BufferedImage image = ImageIO.read(resourceManager.func_110536_a(new ResourceLocation("lemonskin", "textures/icons.png")).func_110527_b());
            DynamicTexture grayTex = new DynamicTexture(GrayIconsReloader.toGrayscale(image));
            ResourceLocation rl = new ResourceLocation("lemonskin", "icons_gray");
            Minecraft.func_71410_x().func_110434_K().func_110579_a(rl, (ITextureObject)grayTex);
            LemonSkin.grayIcons = rl;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to reload gray icons", e);
        }
    }

    private static BufferedImage toGrayscale(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        BufferedImage grayImg = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb = img.getRGB(x, y);
                Color c = new Color(rgb, true);
                int gray = (int)(0.299 * (double)c.getRed() + 0.587 * (double)c.getGreen() + 0.114 * (double)c.getBlue());
                Color newColor = new Color(gray, gray, gray, c.getAlpha());
                grayImg.setRGB(x, y, newColor.getRGB());
            }
        }
        return grayImg;
    }
}

