/*
 * Decompiled with CFR 0.152.
 */
package ua.myxazaur.lemonskin.helpers;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import ua.myxazaur.lemonskin.LemonSkin;
import ua.myxazaur.lemonskin.helpers.AppleCoreHelper;
import ua.myxazaur.lemonskin.mixin.vanilla.ItemFoodAccessor;

public class FoodHelper {
    public static boolean isFood(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_190926_b()) {
            return false;
        }
        if (LemonSkin.hasAppleCore) {
            return AppleCoreHelper.isFood(itemStack);
        }
        return itemStack.func_77973_b() instanceof ItemFood;
    }

    public static boolean isRotten(ItemStack itemStack) {
        PotionEffect effect = FoodHelper.getEffect(itemStack);
        return effect != null && effect.func_188419_a() == MobEffects.field_76438_s;
    }

    public static PotionEffect getEffect(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_190926_b()) {
            return null;
        }
        if (!FoodHelper.isFood(itemStack)) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        try {
            if (!(item instanceof ItemFood)) {
                return null;
            }
            ItemFood itemFood = (ItemFood)item;
            return ((ItemFoodAccessor)itemFood).getPotionId();
        }
        catch (Exception e) {
            LemonSkin.Log.error("Error getting potion id", (Throwable)e);
            return null;
        }
    }

    public static BasicFoodValues getDefaultFoodValues(ItemStack itemStack) {
        if (LemonSkin.hasAppleCore) {
            return AppleCoreHelper.getDefaultFoodValues(itemStack);
        }
        ItemFood itemFood = (ItemFood)itemStack.func_77973_b();
        int hunger = itemFood.func_150905_g(itemStack);
        float saturationModifier = itemFood.func_150906_h(itemStack);
        return new BasicFoodValues(hunger, saturationModifier);
    }

    public static BasicFoodValues getModifiedFoodValues(ItemStack itemStack, EntityPlayer player) {
        if (LemonSkin.hasAppleCore) {
            return AppleCoreHelper.getModifiedFoodValues(itemStack, player);
        }
        return FoodHelper.getDefaultFoodValues(itemStack);
    }

    public static class BasicFoodValues {
        public final int hunger;
        public final float saturationModifier;

        public BasicFoodValues(int hunger, float saturationModifier) {
            this.hunger = hunger;
            this.saturationModifier = saturationModifier;
        }

        public float getSaturationIncrement() {
            return (float)this.hunger * this.saturationModifier * 2.0f;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BasicFoodValues)) {
                return false;
            }
            BasicFoodValues that = (BasicFoodValues)o;
            return this.hunger == that.hunger && Float.compare(that.saturationModifier, this.saturationModifier) == 0;
        }

        public int hashCode() {
            int result = this.hunger;
            result = 31 * result + (this.saturationModifier != 0.0f ? Float.floatToIntBits(this.saturationModifier) : 0);
            return result;
        }
    }
}

