/*
 * Decompiled with CFR 0.152.
 */
package ua.myxazaur.lemonskin.helpers;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import ua.myxazaur.lemonskin.LemonSkin;
import ua.myxazaur.lemonskin.ModConfig;
import ua.myxazaur.lemonskin.helpers.AppleCoreHelper;
import ua.myxazaur.lemonskin.helpers.BetterWithModsHelper;
import ua.myxazaur.lemonskin.helpers.FoodHelper;
import ua.myxazaur.lemonskin.helpers.KeyHelper;

public class TooltipHelper {
    public static void reserveFoodTooltipSpace(List<String> tooltip, ItemStack stack) {
        boolean shouldShow;
        boolean bl = shouldShow = ModConfig.CLIENT.SHOW_FOOD_VALUES_IN_TOOLTIP && KeyHelper.isShiftKeyDown() || ModConfig.CLIENT.ALWAYS_SHOW_FOOD_VALUES_TOOLTIP;
        if (!shouldShow || !FoodHelper.isFood(stack)) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        FoodHelper.BasicFoodValues base = FoodHelper.getDefaultFoodValues(stack);
        FoodHelper.BasicFoodValues actual = FoodHelper.getModifiedFoodValues(stack, (EntityPlayer)player);
        if (LemonSkin.hasAppleCore) {
            base = AppleCoreHelper.getFoodValuesForDisplay(base, (EntityPlayer)player);
            actual = AppleCoreHelper.getFoodValuesForDisplay(actual, (EntityPlayer)player);
        }
        if ((base = BetterWithModsHelper.getFoodValuesForDisplay(base)).equals(actual = BetterWithModsHelper.getFoodValuesForDisplay(actual)) && base.hunger == 0) {
            return;
        }
        int biggestHunger = Math.max(base.hunger, actual.hunger);
        float biggestSatInc = Math.max(base.getSaturationIncrement(), actual.getSaturationIncrement());
        int hungerBars = (int)Math.ceil((float)Math.abs(biggestHunger) / 2.0f);
        int satBars = (int)Math.max(1.0, Math.ceil(Math.abs(biggestSatInc) / 2.0f));
        float scale = 2.2f;
        float hungerLen = hungerBars < 10 ? (float)hungerBars * scale : 2.0f;
        float satLen = satBars < 10 ? (float)satBars * scale * 0.8f : 2.0f;
        int spacesNeeded = (int)Math.ceil(Math.max(hungerLen, satLen));
        StringBuilder sb = new StringBuilder("\u00a0");
        for (int i = 0; i < spacesNeeded; ++i) {
            sb.append("\u00a0");
        }
        tooltip.add(sb.toString());
        tooltip.add(sb.toString());
    }
}

