/*
 * Decompiled with CFR 0.152.
 */
package ua.myxazaur.lemonskin.mixin.forge;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.FoodStats;
import net.minecraftforge.client.GuiIngameForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ua.myxazaur.lemonskin.LemonSkin;
import ua.myxazaur.lemonskin.ModConfig;
import ua.myxazaur.lemonskin.client.HUDOverlayRenderer;
import ua.myxazaur.lemonskin.helpers.AppleCoreHelper;
import ua.myxazaur.lemonskin.helpers.FoodHelper;
import ua.myxazaur.lemonskin.helpers.HealthHelper;
import ua.myxazaur.lemonskin.helpers.HungerHelper;
import ua.myxazaur.lemonskin.mixin.vanilla.GuiIngameAccessor;

@Mixin(value={GuiIngameForge.class})
public abstract class GuiIngameForgeMixin {
    @Inject(method={"renderFood"}, at={@At(value="INVOKE", target="Lnet/minecraft/profiler/Profiler;func_76320_a(Ljava/lang/String;)V")}, remap=false)
    public void preRenderFood(int width, int height, CallbackInfo ci) {
        if (!ModConfig.CLIENT.SHOW_FOOD_EXHAUSTION_UNDERLAY) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        int left = width / 2 + 91;
        int top = height - GuiIngameForge.right_height;
        HUDOverlayRenderer.drawExhaustionOverlay(HungerHelper.getExhaustion((EntityPlayer)player), mc, left, top, 1.0f);
    }

    @Inject(method={"renderFood"}, at={@At(value="TAIL")}, remap=false)
    public void postRenderFood(int width, int height, CallbackInfo ci) {
        if (!ModConfig.CLIENT.SHOW_FOOD_VALUES_OVERLAY && !ModConfig.CLIENT.SHOW_SATURATION_OVERLAY) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        int updateCounter = ((GuiIngameAccessor)mc.field_71456_v).getUpdateCounter();
        ItemStack held = player.func_184614_ca();
        if (!FoodHelper.isFood(held)) {
            held = player.func_184592_cb();
        }
        FoodStats stats = player.func_71024_bL();
        int left = width / 2 + 91;
        int top = height - GuiIngameForge.right_height + 10;
        if (ModConfig.CLIENT.SHOW_SATURATION_OVERLAY) {
            HUDOverlayRenderer.drawSaturationOverlay(0.0f, stats.func_75115_e(), mc, left, top, 1.0f, updateCounter);
        }
        if (!ModConfig.CLIENT.SHOW_FOOD_VALUES_OVERLAY || !FoodHelper.isFood(held)) {
            LemonSkin.tickHandler.flashAlpha = 0.0f;
            LemonSkin.tickHandler.alphaDir = 1;
            return;
        }
        FoodHelper.BasicFoodValues values = FoodHelper.getModifiedFoodValues(held, (EntityPlayer)player);
        if (LemonSkin.hasAppleCore) {
            values = AppleCoreHelper.getFoodValuesForDisplay(values, (EntityPlayer)player);
        }
        HUDOverlayRenderer.drawHungerOverlay(values.hunger, stats.func_75116_a(), mc, left, top, LemonSkin.tickHandler.flashAlpha, FoodHelper.isRotten(held), updateCounter);
        if (ModConfig.CLIENT.SHOW_SATURATION_OVERLAY) {
            int newFoodValue = stats.func_75116_a() + values.hunger;
            float newSaturationValue = stats.func_75115_e() + values.getSaturationIncrement();
            HUDOverlayRenderer.drawSaturationOverlay(newSaturationValue > (float)newFoodValue ? (float)newFoodValue - stats.func_75115_e() : values.getSaturationIncrement(), stats.func_75115_e(), mc, left, top, LemonSkin.tickHandler.flashAlpha, updateCounter);
        }
    }

    @Inject(method={"renderHealth"}, at={@At(value="TAIL")}, remap=false)
    public void postRenderHealth(int width, int height, CallbackInfo ci) {
        float heal;
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (!HUDOverlayRenderer.shouldShowEstimatedHealth((EntityPlayer)player)) {
            return;
        }
        int updateCounter = ((GuiIngameAccessor)mc.field_71456_v).getUpdateCounter();
        ItemStack held = player.func_184614_ca();
        if (!FoodHelper.isFood(held)) {
            held = player.func_184592_cb();
        }
        if (!FoodHelper.isFood(held)) {
            return;
        }
        FoodHelper.BasicFoodValues values = FoodHelper.getModifiedFoodValues(held, (EntityPlayer)player);
        if (LemonSkin.hasAppleCore) {
            values = AppleCoreHelper.getFoodValuesForDisplay(values, (EntityPlayer)player);
        }
        PotionEffect effect = FoodHelper.getEffect(held);
        if (held.func_77973_b() == Items.field_151153_ao) {
            effect = held.func_77960_j() > 0 ? new PotionEffect(MobEffects.field_76428_l, 400, 1) : new PotionEffect(MobEffects.field_76428_l, 100, 1);
        }
        if ((heal = HealthHelper.getEstimatedHealthIncrement((EntityPlayer)player, values, effect)) <= 0.0f) {
            return;
        }
        float currentHealth = player.func_110143_aJ();
        float newHealth = Math.min(currentHealth + heal, player.func_110138_aP());
        int left = width / 2 - 91;
        int top = height - GuiIngameForge.right_height;
        HUDOverlayRenderer.drawHealthOverlay(currentHealth, newHealth, mc, left, top, LemonSkin.tickHandler.flashAlpha, updateCounter);
    }
}

